import { vec2, vec4 } from "./vec";
import { Keybd } from "./Keybd";
import { Mouse } from "./Mouse";
export declare const enum WindowFlags {
    FullScreen = 1,
    Shown = 4,
    Hidden = 8,
    Borderless = 16,
    Resizable = 32,
    Minimized = 64,
    Maximized = 128,
    InputGrabbed = 256,
    InputFocus = 512,
    MouseFocus = 1024,
    FullScreenDesktop = 4097,
    MouseCapture = 16384
}
export declare const enum FullScreenMode {
    FullScreen = 1,
    DesktopFullScreen = 4097
}
export interface WindowRef {
    getFlags(): WindowFlags;
    getMaximumSize(): vec2;
    getMinimumSize(): vec2;
    getOpacity(): number;
    getPosition(): vec4;
    getSize(): vec2;
    getTitle(): string;
    hide(): void;
    maximize(): void;
    minimize(): void;
    raise(): void;
    restore(): void;
    setBordered(bordered: boolean): void;
    setFullScreen(mode: FullScreenMode): void;
    setInputFocus(): void;
    setMaximumSize(size: vec2): void;
    setMinimumSize(size: vec2): void;
    setOpacity(opacity: number): void;
    setPosition(pos: vec2): void;
    setResizable(resizable: boolean): void;
    setSize(size: vec2): void;
    setTitle(title: string): void;
    show(): void;
    equalsTo(other: WindowRef): boolean;
}
export interface SDL {
    Keybd: Keybd;
    Mouse: Mouse;
    Clipboard: Clipboard;
}
