export declare const enum RunState {
    Paused = 0,
    Stepping = 1,
    Running = 2
}
export declare const enum Register {
    r0 = 0,
    at = 1,
    v0 = 2,
    v1 = 3,
    a0 = 4,
    a1 = 5,
    a2 = 6,
    a3 = 7,
    t0 = 8,
    t1 = 9,
    t2 = 10,
    t3 = 11,
    t4 = 12,
    t5 = 13,
    t6 = 14,
    t7 = 15,
    s0 = 16,
    s1 = 17,
    s2 = 18,
    s3 = 19,
    s4 = 20,
    s5 = 21,
    s6 = 22,
    s7 = 23,
    t8 = 24,
    t9 = 25,
    k0 = 26,
    k1 = 27,
    gp = 28,
    sp = 29,
    fp = 30,
    ra = 31
}
export declare const enum BpFlags {
    Enabled = 1,
    Read = 2,
    Write = 4,
    Exec = 8,
    Log = 16,
    All = 31,
    RW = 7,
    RWX = 15
}
export interface BpStruct {
    address: number;
    endAddress: number;
    flags: BpFlags;
}
export interface BpTriggerInfo {
    flags: BpFlags;
    address: number;
}
export declare const enum MemType {
    NoMem = 0,
    Nothing = 1,
    RDRAM = 2,
    RDRAMReg = 3,
    RSPMem = 4,
    RSPReg = 5,
    RSP = 6,
    DP = 7,
    DPS = 8,
    VI = 9,
    AI = 10,
    PI = 11,
    RI = 12,
    SI = 13,
    FlashRAMStat = 14,
    ROM = 15,
    PIF = 16,
    MI = 17,
    Breakpoint = 18
}
export declare const enum MemFlags {
    Readable = 1,
    Writable = 2,
    ReadableEmuOnly = 4,
    WritableEmuOnly = 8
}
export interface Debugger {
    isSupported(): boolean;
    isEnabled(): boolean;
    isInitialized(): boolean;
    getRunState(): RunState;
    setRunState(state: RunState): void;
    step(): void;
    decodeOp(inst: number, pc: number): string;
    memRead64(addr: number): number;
    memRead32(addr: number): number;
    memRead16(addr: number): number;
    memRead8(addr: number): number;
    memWrite64(addr: number, val: number): void;
    memWrite32(addr: number, val: number): void;
    memWrite16(addr: number, val: number): void;
    memWrite8(addr: number, val: number): void;
    bpCount(): number;
    bpLookup(addr: number, size: number, flags: BpFlags): number;
    bpAddAddress(addr: number): number;
    bpAddStruct(bp: BpStruct): number;
    bpReplace(index: number, bp: BpStruct): void;
    bpRemoveAddress(addr: number): void;
    bpRemoveIndex(index: number): void;
    bpEnable(index: number): void;
    bpDisable(index: number): void;
    bpCheck(addr: number): number;
    bpTriggeredBy(): BpTriggerInfo;
    getPrevPC(): number;
    readPC(): number;
    writePC(pc: number): void;
    readRegister(reg: Register): number;
    writeRegister(reg: Register, val: number): void;
    virtualToPhysical(addr: number): number;
    getMemType(addr: number): MemType;
    getMemFlags(addr: number): MemFlags;
}
