"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScarecrowSongNoteStruct = exports.SceneStruct = exports.UpgradeCountLookup = exports.NO_KEYS = exports.OotFlagEventImpl = exports.OotFlagSubTypes = exports.OotFlagTypes = exports.OotEvents = void 0;
// Note: ON_ACTOR_SPAWN/ON_ACTOR_DESPAWN won't detect anything created by ICommandBuffer. This is intentional behavior.
var OotEvents;
(function (OotEvents) {
    OotEvents["ON_SAVE_LOADED"] = "onSaveLoaded";
    OotEvents["ON_SCENE_CHANGE"] = "onSceneChange";
    OotEvents["ON_LOADING_ZONE"] = "onLoadingZone";
    OotEvents["ON_ACTOR_SPAWN"] = "onActorSpawn";
    OotEvents["ON_ACTOR_DESPAWN"] = "onActorDespawn";
    OotEvents["ON_ROOM_CHANGE"] = "onRoomChange";
    OotEvents["ON_ROOM_CHANGE_PRE"] = "onPreRoomChange";
    OotEvents["ON_AGE_CHANGE"] = "onAgeChange";
    OotEvents["ON_SAVE_FLAG_CHANGE"] = "onSaveFlagChange";
    OotEvents["ON_LOCAL_FLAG_CHANGE"] = "onLocalFlagChange";
    OotEvents["ON_DAY_TRANSITION"] = "onDayTransition";
    OotEvents["ON_NIGHT_TRANSITION"] = "onNightTransition";
    OotEvents["ON_HEALTH_CHANGE"] = "onHealthChange";
    OotEvents["ON_TUNIC_CHANGE"] = "onTunicChanged";
})(OotEvents = exports.OotEvents || (exports.OotEvents = {}));
var OotFlagTypes;
(function (OotFlagTypes) {
    OotFlagTypes[OotFlagTypes["SCENE"] = 0] = "SCENE";
    OotFlagTypes[OotFlagTypes["SKULLTULA"] = 1] = "SKULLTULA";
    OotFlagTypes[OotFlagTypes["ITEM"] = 2] = "ITEM";
    OotFlagTypes[OotFlagTypes["INF"] = 3] = "INF";
    OotFlagTypes[OotFlagTypes["EVENT"] = 4] = "EVENT";
})(OotFlagTypes = exports.OotFlagTypes || (exports.OotFlagTypes = {}));
var OotFlagSubTypes;
(function (OotFlagSubTypes) {
    OotFlagSubTypes[OotFlagSubTypes["NONE"] = 0] = "NONE";
    OotFlagSubTypes[OotFlagSubTypes["CHEST"] = 1] = "CHEST";
    OotFlagSubTypes[OotFlagSubTypes["SWITCH"] = 2] = "SWITCH";
    OotFlagSubTypes[OotFlagSubTypes["ROOM_CLEAR"] = 3] = "ROOM_CLEAR";
    OotFlagSubTypes[OotFlagSubTypes["COLLECT"] = 4] = "COLLECT";
    OotFlagSubTypes[OotFlagSubTypes["UNUSED"] = 5] = "UNUSED";
    OotFlagSubTypes[OotFlagSubTypes["VISITED_ROOM"] = 6] = "VISITED_ROOM";
    OotFlagSubTypes[OotFlagSubTypes["VISITED_FLOOR"] = 7] = "VISITED_FLOOR";
})(OotFlagSubTypes = exports.OotFlagSubTypes || (exports.OotFlagSubTypes = {}));
class OotFlagEventImpl {
    constructor(type, subtype, scene, flagNumber, state) {
        this.type = type;
        this.subtype = subtype;
        this.scene = scene;
        this.flagNumber = flagNumber;
        this.state = state;
    }
}
exports.OotFlagEventImpl = OotFlagEventImpl;
exports.NO_KEYS = 0xff;
class UpgradeCount {
    constructor(item, level, count) {
        this.item = item;
        this.level = level;
        this.count = count;
    }
    isMatch(inst) {
        return inst.item === this.item && inst.level === this.level;
    }
}
const UpgradeCountLookupTable = [
    // Bombs
    new UpgradeCount(2 /* BOMB */, 0 /* NONE */, 0),
    new UpgradeCount(2 /* BOMB */, 1 /* BASE */, 20),
    new UpgradeCount(2 /* BOMB */, 2 /* UPGRADED */, 30),
    new UpgradeCount(2 /* BOMB */, 3 /* MAX */, 40),
    // Sticks
    new UpgradeCount(0 /* DEKU_STICK */, 0 /* NONE */, 0),
    new UpgradeCount(0 /* DEKU_STICK */, 1 /* BASE */, 10),
    new UpgradeCount(0 /* DEKU_STICK */, 2 /* UPGRADED */, 20),
    new UpgradeCount(0 /* DEKU_STICK */, 3 /* MAX */, 30),
    // Nuts
    new UpgradeCount(1 /* DEKU_NUT */, 0 /* NONE */, 0),
    new UpgradeCount(1 /* DEKU_NUT */, 1 /* BASE */, 20),
    new UpgradeCount(1 /* DEKU_NUT */, 2 /* UPGRADED */, 30),
    new UpgradeCount(1 /* DEKU_NUT */, 3 /* MAX */, 40),
    // Seeds
    new UpgradeCount(6 /* FAIRY_SLINGSHOT */, 0 /* NONE */, 0),
    new UpgradeCount(6 /* FAIRY_SLINGSHOT */, 1 /* BASE */, 30),
    new UpgradeCount(6 /* FAIRY_SLINGSHOT */, 2 /* UPGRADED */, 40),
    new UpgradeCount(6 /* FAIRY_SLINGSHOT */, 3 /* MAX */, 50),
    // Arrows
    new UpgradeCount(3 /* FAIRY_BOW */, 0 /* NONE */, 0),
    new UpgradeCount(3 /* FAIRY_BOW */, 1 /* BASE */, 30),
    new UpgradeCount(3 /* FAIRY_BOW */, 2 /* UPGRADED */, 40),
    new UpgradeCount(3 /* FAIRY_BOW */, 3 /* MAX */, 50),
    // Bombchu
    new UpgradeCount(9 /* BOMBCHU */, 0 /* NONE */, 0),
    new UpgradeCount(9 /* BOMBCHU */, 1 /* BASE */, 5),
    new UpgradeCount(9 /* BOMBCHU */, 2 /* UPGRADED */, 10),
    new UpgradeCount(9 /* BOMBCHU */, 3 /* MAX */, 20),
];
function UpgradeCountLookup(item, level) {
    let inst = new UpgradeCount(item, level, -1);
    for (let i = 0; i < UpgradeCountLookupTable.length; i++) {
        if (inst.isMatch(UpgradeCountLookupTable[i])) {
            return UpgradeCountLookupTable[i].count;
        }
    }
    return 0;
}
exports.UpgradeCountLookup = UpgradeCountLookup;
class SceneStruct {
    constructor(buf) {
        this.buf = buf;
    }
    get chests() {
        return this.buf.slice(0x0, 0x4);
    }
    get switches() {
        return this.buf.slice(0x4, 0x8);
    }
    get room_clear() {
        return this.buf.slice(0x8, 0xC);
    }
    get collectible() {
        return this.buf.slice(0xC, 0x10);
    }
    get unused() {
        return this.buf.slice(0x10, 0x14);
    }
    get visited_rooms() {
        return this.buf.slice(0x14, 0x18);
    }
    get visited_floors() {
        return this.buf.slice(0x18, 0x1C);
    }
}
exports.SceneStruct = SceneStruct;
class ScarecrowSongNoteStruct {
    constructor(buf) {
        this.buf = buf;
    }
    get note() {
        return this.buf.slice(0x0, 0x1);
    }
    get unused() {
        return this.buf.slice(0x1, 0x2);
    }
    get duration() {
        return this.buf.slice(0x2, 0x4);
    }
    get volume() {
        return this.buf.slice(0x4, 0x5);
    }
    get vibrato() {
        return this.buf.slice(0x5, 0x6);
    }
    get pitch() {
        return this.buf.slice(0x6, 0x7);
    }
    get special() {
        return this.buf.slice(0x7, 0x8);
    }
}
exports.ScarecrowSongNoteStruct = ScarecrowSongNoteStruct;
//# sourceMappingURL=OOTAPI.js.map