/// <reference types="node" />
import IMemory from './IMemory';
import { IRomHeader } from './IRomHeader';
import ISaveState from './ISaveState';
import { IImGui } from './Sylvain/ImGui';
import { SDL } from './Sylvain/SDL';
import { Gfx } from './Sylvain/Gfx';
import { Input } from './Sylvain/Input';
import { IYaz0 } from './Sylvain/Yaz0';
import { Debugger } from './Sylvain/Debugger';
import IUtils from './IUtils';
import { ProxySide } from './SidedProxy/SidedProxy';
import { ILogger } from './IModLoaderAPI';
import { IRomMemory } from './IRomMemory';
interface IConsole {
    startEmulator(preStartCallback: Function): IMemory;
    stopEmulator(): void;
    softReset(): void;
    hardReset(): void;
    saveState(file: string): void;
    loadState(file: string): void;
    finishInjects(): void;
    isEmulatorReady(): boolean;
    getLoadedRom(): Buffer;
    getRomOriginalSize(): number;
    getRomHeader(): IRomHeader;
    pauseEmulator(): void;
    resumeEmulator(): void;
    getMemoryAccess(): IMemory;
    setSaveDir(path: string): void;
    getUtils(): IUtils;
    getFrameCount(): number;
    setFrameCount(num: number): void;
    on(which: string, callback: any): void;
}
interface IConsole {
    getSaveStateManager(): ISaveState;
}
interface IConsole {
    getImGuiAccess(): IImGui;
}
interface IConsole {
    getSDLAccess(): SDL;
}
interface IConsole {
    getGfxAccess(): Gfx;
}
interface IConsole {
    getInputAccess(): Input;
}
interface IConsole {
    getYaz0Encoder(): IYaz0;
}
interface IConsole {
    getDebuggerAccess(): Debugger;
}
interface IConsole {
    getInternalPlugin(): string;
    getRomAccess(): IRomMemory;
}
export interface IConsoleDescriptor {
    constructConsole(side: ProxySide, rom: string, logger: ILogger, lobby: string): IConsole;
    getConsoleLabel(): string;
}
export default IConsole;
