"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExternalAPIData = exports.ExternalAPIProvider = exports.ExternalAPIData = void 0;
const semver_1 = __importDefault(require("semver"));
const EventHandler_1 = require("./EventHandler");
const IModLoaderAPI_1 = require("./IModLoaderAPI");
const ExternalAPIs = new Map();
class ExternalAPIData {
    constructor(name, version, path) {
        this.processed = false;
        this.name = name;
        this.version = version;
        this.path = path;
    }
}
exports.ExternalAPIData = ExternalAPIData;
function ExternalAPIProvider(name, version, path) {
    return (ctor) => {
        if (getExternalAPIData(name) !== undefined) {
            let data = getExternalAPIData(name);
            let builds = [data.version, version];
            builds = semver_1.default.rsort(builds);
            if (builds[0] === version && data.version !== version) {
                ExternalAPIs.set(name, new ExternalAPIData(name, version, path));
                EventHandler_1.bus.emit(IModLoaderAPI_1.ModLoaderEvents.ON_EXTERNAL_API_REGISTER, getExternalAPIData(name));
            }
        }
        else {
            ExternalAPIs.set(name, new ExternalAPIData(name, version, path));
            EventHandler_1.bus.emit(IModLoaderAPI_1.ModLoaderEvents.ON_EXTERNAL_API_REGISTER, getExternalAPIData(name));
        }
    };
}
exports.ExternalAPIProvider = ExternalAPIProvider;
function getExternalAPIData(name) {
    return ExternalAPIs.get(name);
}
exports.getExternalAPIData = getExternalAPIData;
//# sourceMappingURL=ExternalAPIProvider.js.map