"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateEventHandler = exports.EventHandler = exports.bus = exports.markPrototypeProcessed = exports.setupPrivateEventHandlers = exports.setupEventHandlers = exports.EventsClient = exports.EventsServer = exports.EventServerLeft = exports.EventServerJoined = exports.EventBus = void 0;
const eventemitter2_1 = require("eventemitter2");
class EventBus extends eventemitter2_1.EventEmitter2 {
}
exports.EventBus = EventBus;
const bus = Object.freeze(new EventBus());
exports.bus = bus;
function EventHandler(key) {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.eventHandlers === undefined) {
            target.ModLoader['eventHandlers'] = new Map();
        }
        target.ModLoader.eventHandlers.set(key, propertyKey);
    };
}
exports.EventHandler = EventHandler;
function PrivateEventHandler(key) {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.PrivateEventHandler === undefined) {
            target.ModLoader['PrivateEventHandler'] = new Map();
        }
        target.ModLoader.PrivateEventHandler.set(key, propertyKey);
    };
}
exports.PrivateEventHandler = PrivateEventHandler;
class EventServerJoined {
    constructor(player, lobby) {
        this.player = player;
        this.lobby = lobby;
    }
}
exports.EventServerJoined = EventServerJoined;
class EventServerLeft extends EventServerJoined {
}
exports.EventServerLeft = EventServerLeft;
var EventsServer;
(function (EventsServer) {
    EventsServer["ON_LOBBY_CREATE"] = "lobbyCreated_server";
    EventsServer["ON_LOBBY_JOIN"] = "lobbyJoin_server";
    EventsServer["ON_LOBBY_LEAVE"] = "lobbyLeave_server";
    EventsServer["ON_PLUGIN_READY"] = "pluginReady_server";
    EventsServer["ON_VERSION_CHECK"] = "versioncheck_server";
    EventsServer["ON_LOBBY_DATA"] = "lobbyData_server";
})(EventsServer = exports.EventsServer || (exports.EventsServer = {}));
var EventsClient;
(function (EventsClient) {
    EventsClient["ON_LOBBY_CREATE"] = "lobbyJoined_client";
    EventsClient["CONFIGURE_LOBBY"] = "configureLobby_client";
    EventsClient["ON_SERVER_CONNECTION"] = "onServerConnection_client";
    EventsClient["ON_PLAYER_LEAVE"] = "playerLeave_client";
    EventsClient["ON_PLAYER_JOIN"] = "playerJoin_client";
    EventsClient["ON_LOBBY_JOIN"] = "lobbyJoined_client";
    EventsClient["ON_PLUGIN_READY"] = "pluginReady_client";
    EventsClient["ON_INJECT_FINISHED"] = "plugins_injectFinished";
    EventsClient["ON_PAYLOAD_INJECTED"] = "plugins_OnPayloadInjected";
    EventsClient["ON_HEAP_READY"] = "ON_HEAP_READY";
})(EventsClient = exports.EventsClient || (exports.EventsClient = {}));
function setupEventHandlers(instance, _bus) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('eventHandlers')) {
            p.ModLoader.eventHandlers.forEach(function (value, key) {
                let a = instance[value].bind(instance);
                _bus.addListener(key, a);
            });
        }
    }
}
exports.setupEventHandlers = setupEventHandlers;
function setupPrivateEventHandlers(instance, _bus) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('PrivateEventHandler')) {
            p.ModLoader.PrivateEventHandler.forEach(function (value, key) {
                let a = instance[value].bind(instance);
                _bus.addListener(key, a);
            });
        }
    }
}
exports.setupPrivateEventHandlers = setupPrivateEventHandlers;
function markPrototypeProcessed(instance) {
    let p = Object.getPrototypeOf(instance);
    if (!p.hasOwnProperty('ModLoader')) {
        return;
    }
    p['ModLoader']['hasBeenProcessed'] = true;
}
exports.markPrototypeProcessed = markPrototypeProcessed;
//# sourceMappingURL=EventHandler.js.map