/// <reference types="node" />
import and from './and';
import create from './create';
import modify from './modify';
import nand from './nand';
import nor from './nor';
import not from './not';
import or from './or';
import read from './read';
import readInt from './read-int';
import readUInt from './read-u-int';
import xnor from './xnor';
import xor from './xor';
export { and, create, modify, nand, nor, not, or, read, readInt, readUInt, xnor, xor, };
declare const _default: {
    and: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    create: (bits: import("../types").Bits) => Buffer;
    modify: (buffer: Buffer, bits: import("../types").Bits, offset?: number) => void;
    nand: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    nor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    not: (buffer: Buffer) => Buffer;
    or: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    read: (buffer: Buffer, offset?: number, length?: number | undefined) => import("../types").Bits;
    readInt: (buffer: Buffer, offset?: number, length?: number) => number;
    readUInt: (buffer: Buffer, offset?: number, length?: number) => number;
    xnor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    xor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
};
export default _default;
