"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupBindVar = exports.BindVar = void 0;
function BindVar(addr, size, offset) {
    return function (target, key) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.BindVar === undefined) {
            target.ModLoader['BindVar'] = new Map();
        }
        target.ModLoader.BindVar.set(key, new BindVar_Container(addr, size, offset));
    };
}
exports.BindVar = BindVar;
function setupBindVar(instance, mem) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('BindVar')) {
            // Bind the variables
            let fields = p.ModLoader.BindVar;
            fields.forEach((value, key) => {
                switch (value.size) {
                    case 0 /* u8 */:
                        Object.defineProperty(instance, key, {
                            get: () => { if (value.offset === undefined) {
                                return mem.rdramRead8(value.addr);
                            }
                            else {
                                return mem.rdramReadPtr8(value.addr, value.offset);
                            } },
                            set: (s) => { if (value.offset === undefined) {
                                mem.rdramWrite8(value.addr, s);
                            }
                            else {
                                mem.rdramWritePtr8(value.addr, value.offset, s);
                            } }
                        });
                        break;
                    case 1 /* u16 */:
                        Object.defineProperty(instance, key, {
                            get: () => { if (value.offset === undefined) {
                                return mem.rdramRead16(value.addr);
                            }
                            else {
                                return mem.rdramReadPtr16(value.addr, value.offset);
                            } },
                            set: (s) => { if (value.offset === undefined) {
                                mem.rdramWrite16(value.addr, s);
                            }
                            else {
                                mem.rdramWritePtr16(value.addr, value.offset, s);
                            } }
                        });
                        break;
                    case 2 /* u32 */:
                        Object.defineProperty(instance, key, {
                            get: () => { if (value.offset === undefined) {
                                return mem.rdramRead32(value.addr);
                            }
                            else {
                                return mem.rdramReadPtr32(value.addr, value.offset);
                            } },
                            set: (s) => { if (value.offset === undefined) {
                                mem.rdramWrite32(value.addr, s);
                            }
                            else {
                                mem.rdramWritePtr32(value.addr, value.offset, s);
                            } }
                        });
                        break;
                }
            });
        }
    }
}
exports.setupBindVar = setupBindVar;
class BindVar_Container {
    constructor(addr, size, offset) {
        this.addr = addr;
        this.size = size;
        if (this.offset !== undefined) {
            this.offset = offset;
        }
    }
}
//# sourceMappingURL=BindVar.js.map