/// <reference types="node" />
import bits from './bits';
import buffer from './buffer';
import byte from './byte';
import integer from './integer';
import nibble from './nibble';
import string from './string';
export { bits, buffer, byte, integer, nibble, string };
declare const bitwise: {
    bits: {
        and: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
        circularShiftLeft: (bits: import("./types").Bits, amount: number) => import("./types").Bits;
        circularShiftRight: (bits: import("./types").Bits, amount: number) => import("./types").Bits;
        nand: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
        nor: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
        not: (bits: import("./types").Bits) => import("./types").Bits;
        or: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
        reduceAnd: (bits: import("./types").Bits) => import("./types").Bit;
        reduceNand: (bits: import("./types").Bits) => import("./types").Bit;
        reduceNor: (bits: import("./types").Bits) => import("./types").Bit;
        reduceOr: (bits: import("./types").Bits) => import("./types").Bit;
        reduceXnor: (bits: import("./types").Bits) => import("./types").Bit;
        reduceXor: (bits: import("./types").Bits) => import("./types").Bit;
        toBoolean: (bits: import("./types").Bits) => import("./types").BooleanBits;
        toString: (bits: import("./types").Bits, spacing?: number, spacer?: string) => string;
        xnor: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
        xor: (bits1: import("./types").Bits, bits2: import("./types").Bits) => import("./types").Bits;
    };
    buffer: {
        and: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        create: (bits: import("./types").Bits) => Buffer;
        modify: (buffer: Buffer, bits: import("./types").Bits, offset?: number) => void;
        nand: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        nor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        not: (buffer: Buffer) => Buffer;
        or: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        read: (buffer: Buffer, offset?: number, length?: number | undefined) => import("./types").Bits;
        readInt: (buffer: Buffer, offset?: number, length?: number) => number;
        readUInt: (buffer: Buffer, offset?: number, length?: number) => number;
        xnor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        xor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    };
    byte: {
        read: (byte: import("./types").UInt8) => import("./types").Byte;
        write: (byte: import("./types").Byte) => import("./types").UInt8;
    };
    integer: {
        getBit: (int32: number, position: number) => import("./types").Bit;
        setBit: (int32: number, position: number, value: import("./types").Bit) => import("./types").Bit;
        toggleBit: (int32: number, position: number) => number;
    };
    nibble: {
        read: (nibble: import("./types").UInt4) => import("./types").Nibble;
        write: (nibble: import("./types").Nibble) => import("./types").UInt4;
    };
    string: {
        toBits: (string: string) => import("./types").Bits;
    };
};
export default bitwise;
