/// <reference types="node" />
import { vec2, vec4 } from "./vec";
import { WindowRef } from "./SDL";
import { Scancode } from "./Keybd";
export declare const enum Emulator_Callbacks {
    new_frame = "new-frame",
    core_started = "core-started",
    vi_update = "vi-update",
    create_resources = "create-resources"
}
export declare type bool_ref = boolean[];
export declare type number_ref = number[];
export declare type string_ref = string[];
export declare const enum WindowFlags {
    None = 0,
    NoTitleBar = 1,
    NoResize = 2,
    NoMove = 4,
    NoScrollbar = 8,
    NoScrollWithMouse = 16,
    NoCollapse = 32,
    AlwaysAutoResize = 64,
    NoBackground = 128,
    NoSavedSettings = 256,
    NoMouseInputs = 512,
    MenuBar = 1024,
    HorizontalScrollbar = 2048,
    NoFocusOnAppearing = 4096,
    NoBringToFrontOnFocus = 8192,
    AlwaysVerticalScrollbar = 16384,
    AlwaysHorizontalScrollbar = 32768,
    AlwaysUseWindowPadding = 65536,
    NoNavInputs = 262144,
    NoNavFocus = 524288,
    UnsavedDocument = 1048576,
    NoDocking = 2097152,
    NoNav = 786432,
    NoDecoration = 43,
    NoInputs = 786944
}
export declare const enum InputTextFlags {
    None = 0,
    CharsDecimal = 1,
    CharsHexadecimal = 2,
    CharsUppercase = 4,
    CharsNoBlank = 8,
    AutoSelectAll = 16,
    EnterReturnsTrue = 32,
    AllowTabInput = 1024,
    CtrlEnterForNewLine = 2048,
    NoHorizontalScroll = 4096,
    AlwaysInsertMode = 8192,
    ReadOnly = 16384,
    Password = 32768,
    NoUndoRedo = 65536,
    CharsScientific = 131072
}
export declare const enum TreeNodeFlags {
    None = 0,
    Selected = 1,
    Framed = 2,
    AllowItemOverlap = 4,
    NoTreePushOnOpen = 8,
    NoAutoOpenOnLog = 16,
    DefaultOpen = 32,
    OpenOnDoubleClick = 64,
    OpenOnArrow = 128,
    Leaf = 256,
    Bullet = 512,
    FramePadding = 1024,
    SpanAvailWidth = 2048,
    SpanFullWidth = 4096,
    NavLeftJumpsBackHere = 8192,
    CollapsingHeader = 26
}
export declare const enum PopupFlags {
    None = 0,
    MouseButtonLeft = 0,
    MouseButtonRight = 1,
    MouseButtonMiddle = 2,
    MouseButtonMask_ = 31,
    MouseButtonDefault_ = 1,
    NoOpenOverExistingPopup = 32,
    NoOpenOverItems = 64,
    AnyPopupId = 128,
    AnyPopupLevel = 256,
    AnyPopup = 384
}
export declare const enum SelectableFlags {
    None = 0,
    DontClosePopups = 1,
    SpanAllColumns = 2,
    AllowDoubleClick = 4,
    Disabled = 8,
    AllowItemOverlap = 16
}
export declare const enum ComboFlags {
    None = 0,
    PopupAlignLeft = 1,
    HeightSmall = 2,
    HeightRegular = 4,
    HeightLarge = 8,
    HeightLargest = 16,
    NoArrowButton = 32,
    NoPreview = 64
}
export declare const enum TabBarFlags {
    None = 0,
    Reorderable = 1,
    AutoSelectNewTabs = 2,
    TabListPopupButton = 4,
    NoCloseWithMiddleMouseButton = 8,
    NoTabListScrollingButtons = 16,
    NoTooltip = 32,
    FittingPolicyResizeDown = 64,
    FittingPolicyScroll = 128
}
export declare const enum TabItemFlags {
    None = 0,
    UnsavedDocument = 1,
    SetSelected = 2,
    NoCloseWithMiddleMouseButton = 4,
    NoPushId = 8,
    NoTooltip = 16
}
export declare const enum FocusedFlags {
    None = 0,
    ChildWindows = 1,
    RootWindow = 2,
    AnyWindow = 4,
    RootAndChildWindows = 3
}
export declare const enum HoveredFlags {
    None = 0,
    ChildWindows = 1,
    RootWindow = 2,
    AnyWindow = 4,
    AllowWhenBlockedByPopup = 8,
    AllowWhenBlockedByActiveItem = 32,
    AllowWhenOverlapped = 64,
    AllowWhenDisabled = 128,
    RectOnly = 104,
    RootAndChildWindows = 3
}
export declare const enum DockNodeFlags {
    None = 0,
    KeepAliveOnly = 1,
    NoDockingInCentralNode = 4,
    PassthruCentralNode = 8,
    NoSplit = 16,
    NoResize = 32,
    AutoHideTabBar = 64
}
export declare const enum Dir {
    None = -1,
    Left = 0,
    Right = 1,
    Up = 2,
    Down = 3
}
export declare const enum ConfigFlags {
    None = 0,
    NavEnableKeyboard = 1,
    NavEnableGamepad = 2,
    NavEnableSetMousePos = 4,
    NavNoCaptureKeyboard = 8,
    NoMouse = 16,
    NoMouseCursorChange = 32,
    DockingEnable = 64,
    ViewportsEnable = 1024,
    DpiEnableScaleViewports = 16384,
    DpiEnableScaleFonts = 32768,
    IsSRGB = 1048576,
    IsTouchScreen = 2097152
}
export declare const enum BackendFlags {
    None = 0,
    HasGamepad = 1,
    HasMouseCursors = 2,
    HasSetMousePos = 4,
    RendererHasVtxOffset = 8,
    PlatformHasViewports = 1024,
    HasMouseHoveredViewport = 2048,
    RendererHasViewports = 4096
}
export declare const enum Col {
    Text = 0,
    TextDisabled = 1,
    WindowBg = 2,
    ChildBg = 3,
    PopupBg = 4,
    Border = 5,
    BorderShadow = 6,
    FrameBg = 7,
    FrameBgHovered = 8,
    FrameBgActive = 9,
    TitleBg = 10,
    TitleBgActive = 11,
    TitleBgCollapsed = 12,
    MenuBarBg = 13,
    ScrollbarBg = 14,
    ScrollbarGrab = 15,
    ScrollbarGrabHovered = 16,
    ScrollbarGrabActive = 17,
    CheckMark = 18,
    SliderGrab = 19,
    SliderGrabActive = 20,
    Button = 21,
    ButtonHovered = 22,
    ButtonActive = 23,
    Header = 24,
    HeaderHovered = 25,
    HeaderActive = 26,
    Separator = 27,
    SeparatorHovered = 28,
    SeparatorActive = 29,
    ResizeGrip = 30,
    ResizeGripHovered = 31,
    ResizeGripActive = 32,
    Tab = 33,
    TabHovered = 34,
    TabActive = 35,
    TabUnfocused = 36,
    TabUnfocusedActive = 37,
    DockingPreview = 38,
    DockingEmptyBg = 39,
    PlotLines = 40,
    PlotLinesHovered = 41,
    PlotHistogram = 42,
    PlotHistogramHovered = 43,
    TextSelectedBg = 44,
    DragDropTarget = 45,
    NavHighlight = 46,
    NavWindowingHighlight = 47,
    NavWindowingDimBg = 48,
    ModalWindowDimBg = 49
}
export declare const enum StyleVar {
    Alpha = 0,
    WindowPadding = 1,
    WindowRounding = 2,
    WindowBorderSize = 3,
    WindowMinSize = 4,
    WindowTitleAlign = 5,
    ChildRounding = 6,
    ChildBorderSize = 7,
    PopupRounding = 8,
    PopupBorderSize = 9,
    FramePadding = 10,
    FrameRounding = 11,
    FrameBorderSize = 12,
    ItemSpacing = 13,
    ItemInnerSpacing = 14,
    IndentSpacing = 15,
    ScrollbarSize = 16,
    ScrollbarRounding = 17,
    GrabMinSize = 18,
    GrabRounding = 19,
    TabRounding = 20,
    ButtonTextAlign = 21,
    SelectableTextAlign = 22
}
export declare const enum ButtonFlags {
    None = 0,
    MouseButtonLeft = 1,
    MouseButtonRight = 2,
    MouseButtonMiddle = 4
}
export declare const enum ColorEditFlags {
    None = 0,
    NoAlpha = 2,
    NoPicker = 4,
    NoOptions = 8,
    NoSmallPreview = 16,
    NoInputs = 32,
    NoTooltip = 64,
    NoLabel = 128,
    NoSidePreview = 256,
    NoDragDrop = 512,
    NoBorder = 1024,
    AlphaBar = 65536,
    AlphaPreview = 131072,
    AlphaPreviewHalf = 262144,
    HDR = 524288,
    DisplayRGB = 1048576,
    DisplayHSV = 2097152,
    DisplayHex = 4194304,
    Uint8 = 8388608,
    Float = 16777216,
    PickerHueBar = 33554432,
    PickerHueWheel = 67108864,
    InputRGB = 134217728,
    InputHSV = 268435456
}
export declare const enum SliderFlags {
    None = 0,
    ClampOnInput = 16,
    Logarithmic = 32,
    NoRoundToFormat = 64,
    NoInput = 128
}
export declare const enum MouseButton {
    Left = 0,
    Right = 1,
    Middle = 2
}
export declare const enum MouseCursor {
    None = -1,
    Arrow = 0,
    TextInput = 1,
    ResizeAll = 2,
    ResizeNS = 3,
    ResizeEW = 4,
    ResizeNESW = 5,
    ResizeNWSE = 6,
    Hand = 7,
    NotAllowed = 8
}
export declare const enum Cond {
    None = 0,
    Always = 1,
    Once = 2,
    FirstUseEver = 4,
    Appearing = 8
}
export declare const enum DrawCornerFlags {
    None = 0,
    TopLeft = 1,
    TopRight = 2,
    BotLeft = 4,
    BotRight = 8,
    Top = 3,
    Bot = 12,
    Left = 5,
    Right = 10,
    All = 15
}
export declare const enum DrawListFlags {
    None = 0,
    AntiAliasedLines = 1,
    AntiAliasedLinesUseTex = 2,
    AntiAliasedFill = 4,
    AllowVtxOffset = 8
}
export declare const enum ViewportFlags {
    None = 0,
    NoDecoration = 1,
    NoTaskBarIcon = 2,
    NoFocusOnAppearing = 4,
    NoFocusOnClick = 8,
    NoInputs = 16,
    NoRendererClear = 32,
    TopMost = 64,
    Minimized = 128,
    NoAutoMerge = 256,
    CanHostOtherWindows = 512
}
export interface DrawListRef {
    flags: DrawListFlags;
    pushClipRect(clipRectMin: vec2, clipRectMax: vec2, intersectWithCurrentClipRect?: boolean): void;
    pushClipRectFullScreen(): void;
    popClipRect(): void;
    pushTextureId(textureId: number): void;
    popTextureId(): void;
    getClipRectMin(): vec2;
    getClipRectMax(): vec2;
    addLine(p1: vec2, p2: vec2, col: vec4, thickness?: number): void;
    addRect(pMin: vec2, pMax: vec2, col: vec4, rounding?: number, roundingCorners?: DrawCornerFlags, thickness?: number): void;
    addRectFilled(pMin: vec2, pMax: vec2, col: vec4, rounding?: number, roundingCorners?: DrawCornerFlags): void;
    addRectFilledMultiColor(pMin: vec2, pMax: vec2, colUprLeft: vec4, colUprRight: vec4, colBotRight: vec4, colBotLeft: vec4): void;
    addQuad(p1: vec2, p2: vec2, p3: vec2, p4: vec2, col: vec4, thickness?: number): void;
    addQuadFilled(p1: vec2, p2: vec2, p3: vec2, p4: vec2, col: vec4): void;
    addTriangle(p1: vec2, p2: vec2, p3: vec2, col: vec4, thickness?: number): void;
    addTriangleFilled(p1: vec2, p2: vec2, p3: vec2, col: vec4): void;
    addCircle(center: vec2, radius: number, col: vec4, numSegments?: number, thickness?: number): void;
    addCircleFilled(center: vec2, radius: number, col: vec4, numSegments?: number): void;
    addNgon(center: vec2, radius: number, col: vec4, numSegments: number, thickness?: number): void;
    addNgonFilled(center: vec2, radius: number, col: vec4, numSegments: number): void;
    addText(pos: vec2, col: vec4, text: string): void;
    addTextEx(font: FontRef, fontSize: number, pos: vec2, col: vec4, text: string, wrapWidth?: number): void;
    addPolyline(points: vec2[], col: vec4, closed: boolean, thickness: number): void;
    addConvexPolyFilled(points: vec2[], col: vec4): void;
    addBezierCurve(p1: vec2, p2: vec2, p3: vec2, p4: vec2, col: vec4, thickness: number, numSegments?: number): void;
    addImage(textureId: number, pMin: vec2, pMax: vec2, uvMin?: vec2, uvMax?: vec2, col?: vec4): void;
    addImageQuad(textureId: number, p1: vec2, p2: vec2, p3: vec2, p4: vec2, uv1?: vec2, uv2?: vec2, uv3?: vec2, uv4?: vec2, col?: vec4): void;
    addImageRounded(textureId: number, pMin: vec2, pMax: vec2, uvMin: vec2, uvMax: vec2, col: vec4, rounding: number, roundingCorners?: DrawCornerFlags): void;
    pathClear(): void;
    pathLineTo(pos: vec2): void;
    pathLineToMergeDuplicate(pos: vec2): void;
    pathFillConvex(col: vec4): void;
    pathStroke(col: vec4, closed: boolean, thickness?: number): void;
    pathArcTo(center: vec2, radius: number, aMin: number, aMax: number, numSegments?: number): void;
    pathArcToFast(center: vec2, radius: number, aMin12: number, aMax12: number): void;
    pathBezierCurveTo(p2: vec2, p3: vec2, p4: vec2, numSegments?: number): void;
    pathRect(rectMin: vec2, rectMax: vec2, rounding?: number, roundingCorners?: DrawListFlags): void;
    addDrawCmd(): void;
}
export interface FontAtlasRef {
    addFontFromFile(filename: string, sizePixels: number): FontRef;
    addFontFromMemory(font: Buffer, sizePixels: number): FontRef;
    addFontFromMemoryCompressed(compressedFont: Buffer, sizePixels: number): FontRef;
}
export interface FontRef {
    size: number;
    scale: number;
}
export interface IoRef {
    configFlags: ConfigFlags;
    backendFlags: BackendFlags;
    displaySize: vec2;
    deltaTime: number;
    iniSavingRate: number;
    iniFilename?: string;
    logFilename?: string;
    mouseDoubleClickTime: number;
    mouseDoubleClickMaxDist: number;
    mouseDragThreshold: number;
    keyRepeatDelay: number;
    keyRepeatRate: number;
    fonts: FontAtlasRef;
    fontGlobalScale: number;
    fontAllowUserScaling: boolean;
    fontDefault: FontRef;
    displayFramebufferScale: vec2;
    configDockingNoSplit: boolean;
    configDockingWithShift: boolean;
    configDockingAlwaysTabBar: boolean;
    configDockingTransparentPayload: boolean;
    configViewportsNoAutoMerge: boolean;
    configViewportsNoTaskBarIcon: boolean;
    configViewportsNoDecoration: boolean;
    configViewportsNoDefaultParent: boolean;
    configMouseDrawCursor: boolean;
    configInputTextCursorBlink: boolean;
    configWindowsResizeFromEdges: boolean;
    configWindowsMoveFromTitleBarOnly: boolean;
    configWindowsMemoryCompactTimer: boolean;
    backendPlatformName: string;
    backendRendererName: string;
    wantCaptureMouse: boolean;
    wantCaptureKeyboard: boolean;
    wantTextInput: boolean;
    wantSetMousePos: boolean;
    wantSaveIniSettings: boolean;
    navActive: boolean;
    navVisible: boolean;
    framerate: number;
    metricsRenderVertices: number;
    metricsRenderWindows: number;
    metricsActiveWindows: number;
    metricsActiveAllocations: number;
    mouseDelta: vec2;
    mouseWheel: vec2;
}
export interface StyleRef {
    alpha: number;
    windowPadding: vec2;
    windowRounding: number;
    windowBorderSize: number;
    windowMinSize: vec2;
    windowTitleAlign: vec2;
    windowMenuButtonPosition: Dir;
    childRounding: number;
    childBorderSize: number;
    popupRounding: number;
    popupBorderSize: number;
    framePadding: vec2;
    frameRounding: number;
    frameBorderSize: number;
    itemSpacing: vec2;
    itemInnerSpacing: vec2;
    touchExtraPadding: vec2;
    indentSpacing: number;
    columnsMinSpacing: number;
    scrollbarSize: number;
    scrollbarRounding: number;
    grabMinSize: number;
    grabRounding: number;
    logSliderDeadzone: number;
    tabRounding: number;
    tabBorderSize: number;
    tabMinWidthForUnselectedCloseButton: number;
    colorButtonPosition: Dir;
    buttonTextAlign: vec2;
    selectableTextAlign: vec2;
    displayWindowPadding: vec2;
    displaySafeAreaPadding: vec2;
    mouseCursorScale: number;
    antiAliasedLines: boolean;
    antiAliasedFill: boolean;
    curveTessallationTol: number;
    circleSegmentMaxError: number;
    getColor(index: Col): vec4;
    setColor(index: Col, col: vec4): void;
    scaleAllSizes(scaleFactor: number): void;
}
export interface ViewportRef {
    id: number;
    flags: ViewportFlags;
    pos: vec2;
    size: vec2;
    workOffsetMin: vec2;
    workOffsetMax: vec2;
    dpiScale: number;
    parentViewportId: number;
    platformHandle?: WindowRef;
    center: vec2;
    workPos: vec2;
    workSize: vec2;
}
export interface IImGui {
    getIo(): IoRef;
    getStyle(): StyleRef;
    showDemoWindow(open?: bool_ref): void;
    showAboutWindow(open?: bool_ref): void;
    showMetricsWindow(open?: bool_ref): void;
    showStyleEditor(): void;
    showStyleSelector(): void;
    showFontSelector(): void;
    showUserGuide(): void;
    getVersion(): string;
    styleColorsDark(): void;
    styleColorsClassic(): void;
    styleColorsLight(): void;
    begin(name: string, open?: bool_ref, flags?: WindowFlags): boolean;
    end(): void;
    beginChild(strId: string, size?: vec2, border?: boolean, flags?: WindowFlags): boolean;
    beginChild(id: number, size?: vec2, border?: boolean, flags?: WindowFlags): boolean;
    endChild(): void;
    isWindowAppearing(): boolean;
    isWindowCollapsed(): boolean;
    isWindowFocused(flags?: FocusedFlags): boolean;
    isWindowHovered(flags?: HoveredFlags): boolean;
    getWindowDrawList(): DrawListRef;
    getWindowDpiScale(): number;
    getWindowViewport(): ViewportRef;
    getWindowPos(): vec2;
    getWindowSize(): vec2;
    getWindowWidth(): number;
    getWindowHeight(): number;
    setNextWindowPos(pos: vec2, cond?: Cond, pivot?: vec2): void;
    setNextWindowSize(size: vec2, cond?: Cond): void;
    setNextWindowSizeConstraints(sizeMin: vec2, sizeMax: vec2): void;
    setNextWindowContentSize(size: vec2): void;
    setNextWindowCollapsed(collapsed: boolean, cond?: Cond): void;
    setNextWindowFocus(): void;
    setNextWindowBgAlpha(alpha: number): void;
    setNextWindowViewport(viewportId: number): void;
    setWindowPos(pos: vec2, cond?: Cond): void;
    setWindowSize(size: vec2, cond?: Cond): void;
    setWindowCollapsed(collapsed: boolean, cond?: Cond): void;
    setWindowFocus(): void;
    setWindowFontScale(scale: number): void;
    setWindowPos(name: string, pos: vec2, cond?: Cond): void;
    setWindowSize(name: string, size: vec2, cond?: Cond): void;
    setWindowCollapsed(name: string, collapsed: boolean, cond?: Cond): void;
    setWindowFocus(name: string): void;
    getContentRegionMax(): vec2;
    getContentRegionAvail(): vec2;
    getWindowContentRegionMin(): vec2;
    getWindowContentRegionMax(): vec2;
    getWindowContentRegionWidth(): number;
    getScrollX(): number;
    getScrollY(): number;
    getScrollMaxX(): number;
    getScrollMaxY(): number;
    setScrollX(scrollX: number): void;
    setScrollY(scrollY: number): void;
    setScrollHereX(centerXRatio?: number): void;
    setScrollHereY(centerYRatio?: number): void;
    setScrollFromPosX(localX: number, centerXRatio?: number): void;
    setScrollFromPosY(localY: number, centerYRatio?: number): void;
    pushFont(font?: FontRef): void;
    popFont(): void;
    pushStyleColor(idx: Col, col: vec4): void;
    popStyleColor(count?: number): void;
    pushStyleVar(idx: StyleVar, val: number): void;
    pushStyleVar(idx: StyleVar, val: vec2): void;
    popStyleVar(count?: number): void;
    getStyleColor(idx: Col): vec4;
    getFont(): FontRef;
    getFontSize(): number;
    getFontTexUvWhitePixel(): vec2;
    getColor(idx: Col, alphaMul?: number): vec4;
    getColor(col: vec4): vec4;
    pushItemWidth(itemWidth: number): void;
    popItemWidth(): void;
    setNextItemWidth(itemWidth: number): void;
    calcItemWidth(): number;
    pushTextWrapPos(wrapLocalPosX?: number): void;
    popTextWrapPos(): void;
    pushAllowKeyboardFocus(allowKeyboardFocus: boolean): void;
    popAllowKeyboardFocus(): void;
    pushButtonRepeat(repeat: boolean): void;
    popButtonRepeat(): void;
    separator(): void;
    sameLine(offsetFromStartX?: number, spacing?: number): void;
    newLine(): void;
    spacing(): void;
    dummy(size: vec2): void;
    indent(indentW?: number): void;
    unindent(indentW?: number): void;
    beginGroup(): void;
    endGroup(): void;
    getCursorPos(): vec2;
    getCursorPosX(): number;
    getCursorPosY(): number;
    setCursorPos(localPos: vec2): void;
    setCursorPosX(localX: number): void;
    setCursorPosY(localY: number): void;
    getCursorStartPos(): vec2;
    getCursorScreenPos(): vec2;
    setCursorScreenPos(pos: vec2): void;
    alignTextToFramePadding(): void;
    getTextLineHeight(): number;
    getTextLineHeightWithSpacing(): number;
    getFrameHeight(): number;
    getFrameHeightWithSpacing(): number;
    pushId(strId: string): void;
    pushId(ptrId: number): void;
    popId(): void;
    getId(strId: string): number;
    getId(ptrId: number): number;
    text(text: string): void;
    textColored(text: string, col: vec4): void;
    textDisabled(text: string): void;
    textWrapped(text: string): void;
    labelText(label: string, text: string): void;
    bulletText(text: string): void;
    button(label: string, size?: vec2): boolean;
    smallButton(label: string): boolean;
    invisibleButton(strId: string, size: vec2, flags?: ButtonFlags): boolean;
    arrowButton(strId: string, dir: Dir): boolean;
    image(userTextureId: number, size: vec2, uv0?: vec2, uv1?: vec2, tintCol?: vec4, borderCol?: vec4): void;
    imageButton(userTextureId: number, size: vec2, uv0?: vec2, uv1?: vec2, framePadding?: number, bgCol?: vec4, tintCol?: vec4): boolean;
    checkbox(label: string, v: bool_ref): boolean;
    checkboxFlags(label: string, flags: number_ref, flagsValue: number): boolean;
    radioButton(label: string, active: boolean): boolean;
    radioButton(label: string, v: number_ref, vButton: number): boolean;
    progressBar(fraction: number, sizeArg?: vec2, overlay?: string): void;
    bullet(): void;
    beginCombo(label: string, previewValue: string, flags?: ComboFlags): boolean;
    endCombo(): void;
    combo(label: string, currentItem: number_ref, items: any[], popupMaxHeightInItems?: number): boolean;
    dragFloat(label: string, v: number_ref, vSpeed?: number, vMin?: number, vMax?: number, format?: string, flags?: SliderFlags): boolean;
    dragFloats(label: string, v: number[], vSpeed?: number, vMin?: number, vMax?: number, format?: string, flags?: SliderFlags): boolean;
    dragFloatRange(label: string, vCurrentMin: number_ref, vCurrentMax: number_ref, vSpeed?: number, vMin?: number, vMax?: number, format?: string, formatMax?: string, flags?: SliderFlags): boolean;
    dragInt(label: string, v: number_ref, vSpeed?: number, vMin?: number, vMax?: number, format?: string, flags?: SliderFlags): boolean;
    dragInts(label: string, v: number[], vSpeed?: number, vMin?: number, vMax?: number, format?: string, flags?: SliderFlags): boolean;
    dragIntRange(label: string, vCurrentMin: number_ref, vCurrentMax: number_ref, vSpeed?: number, vMin?: number, vMax?: number, format?: string, formatMax?: string, flags?: SliderFlags): boolean;
    sliderFloat(label: string, v: number_ref, vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    sliderFloats(label: string, v: number[], vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    sliderAngle(label: string, vRad: number_ref, vDegreesMin?: number, vDegreesMax?: number, format?: string, flags?: SliderFlags): boolean;
    sliderInt(label: string, v: number_ref, vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    sliderInts(label: string, v: number[], vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    vSliderFloat(label: string, size: vec2, v: number_ref, vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    vSliderInt(label: string, size: vec2, v: number_ref, vMin: number, vMax: number, format?: string, flags?: SliderFlags): boolean;
    inputText(label: string, text: string_ref, flags?: InputTextFlags): boolean;
    inputTextMultiline(label: string, text: string_ref, size?: vec2, flags?: InputTextFlags): boolean;
    inputTextWithHint(label: string, hint: string, text: string_ref, flags?: InputTextFlags): boolean;
    inputFloat(label: string, v: number_ref, step?: number, stepFast?: number, format?: string, flags?: InputTextFlags): boolean;
    inputFloats(label: string, v: number[], step?: number, stepFast?: number, format?: string, flags?: InputTextFlags): boolean;
    inputInt(label: string, v: number_ref, step?: number, stepFast?: number, flags?: InputTextFlags): boolean;
    inputInts(label: string, v: number[], step?: number, stepFast?: number, format?: string, flags?: InputTextFlags): boolean;
    inputDouble(label: string, v: number_ref, step?: number, stepFast?: number, format?: string, flags?: InputTextFlags): boolean;
    colorEdit3(label: string, col: vec4, flags?: ColorEditFlags): boolean;
    colorEdit4(label: string, col: vec4, flags?: ColorEditFlags): boolean;
    colorPicker3(label: string, col: vec4, flags?: ColorEditFlags): boolean;
    colorPicker4(label: string, col: vec4, flags?: ColorEditFlags, refColor?: vec4): boolean;
    colorButton(descId: string, col: vec4, flags?: ColorEditFlags, size?: vec2): boolean;
    setColorEditOptions(flags: ColorEditFlags): void;
    treeNode(label: string, flags?: TreeNodeFlags): boolean;
    treeNodeEx(strId: string, label: string, flags?: TreeNodeFlags): boolean;
    treeNodeEx(ptrId: number, label: string, flags?: TreeNodeFlags): boolean;
    treePush(strId: string): void;
    treePush(ptrId: number): void;
    treePush(): void;
    treePop(): void;
    getTreeNodeToLabelSpacing(): number;
    collapsingHeader(label: string, flags?: TreeNodeFlags): boolean;
    collapsingHeader(label: string, open: bool_ref, flags?: TreeNodeFlags): boolean;
    setNextItemOpen(isOpen: boolean, cond?: Cond): void;
    selectable(label: string, selected?: boolean, flags?: SelectableFlags, size?: vec2): boolean;
    selectable(label: string, selected: bool_ref, flags?: SelectableFlags, size?: vec2): boolean;
    listBox(label: string, currentItem: number_ref, items: any[], heightInItems?: number): boolean;
    listBoxHeader(label: string, size?: vec2): boolean;
    listBoxHeader(label: string, itemsCount: number, heightInItems?: number): boolean;
    listBoxFooter(): void;
    plotLines(label: string, values: number[], valuesOffset?: number, overlayText?: string, scaleMin?: number, scaleMax?: number, graphSize?: vec2): void;
    plotHistogram(label: string, values: number[], valuesOffset?: number, overlayText?: string, scaleMin?: number, scaleMax?: number, graphSize?: vec2): void;
    valueBool(prefix: string, b: boolean): void;
    valueInt(prefix: string, v: number): void;
    valueFloat(prefix: string, v: number, format?: string): void;
    beginMenuBar(): boolean;
    endMenuBar(): void;
    beginMainMenuBar(): boolean;
    endMainMenuBar(): void;
    beginMenu(label: string, enabled?: boolean): boolean;
    endMenu(): void;
    menuItem(label: string, shortcut?: string, selected?: boolean, enabled?: boolean): boolean;
    menuItem(label: string, shortcut: string, selected: bool_ref, enabled?: boolean): boolean;
    beginTooltip(): void;
    endTooltip(): void;
    setTooltip(text: string): void;
    beginPopup(strId: string, flags?: WindowFlags): boolean;
    beginPopupModal(name: string, open?: bool_ref, flags?: WindowFlags): boolean;
    endPopup(): void;
    openPopup(strId: string, popupFlags?: PopupFlags): void;
    openPopupContextItem(strId?: string, popupFlags?: PopupFlags): boolean;
    closeCurrentPopup(): void;
    beginPopupContextItem(strId?: string, popupFlags?: PopupFlags): boolean;
    beginPopupContextWindow(strId?: string, popupFlags?: PopupFlags): boolean;
    beginPopupContextVoid(strId?: string, popupFlags?: PopupFlags): boolean;
    isPopupOpen(strId: string, flags?: PopupFlags): boolean;
    columns(count?: number, id?: string, border?: boolean): void;
    nextColumn(): void;
    getColumnIndex(): number;
    getColumnWidth(columnIndex?: number): number;
    setColumnWidth(columnIndex: number, width: number): void;
    getColumnOffset(columnIndex?: number): number;
    setColumnOffset(columnIndex: number, offsetX: number): void;
    getColumnsCount(): number;
    beginTabBar(strId: string, flags?: TabBarFlags): boolean;
    endTabBar(): void;
    beginTabItem(label: string, open?: bool_ref, flags?: TabItemFlags): boolean;
    endTabItem(): void;
    setTabItemClosed(tabOrDockedWindowLabel: string): void;
    dockSpace(id: number, size?: vec2, flags?: DockNodeFlags): void;
    dockSpaceOverViewport(viewport?: ViewportRef, flags?: DockNodeFlags): void;
    getWindowDockId(): number;
    isWindowDocked(): boolean;
    logToTTY(autoOpenDepth?: number): void;
    logToFile(autoOpenDepth?: number, filename?: string): void;
    logToClipboard(autoOpenDepth?: number): void;
    logFinish(): void;
    logButtons(): void;
    logText(text: string): void;
    pushClipRect(clipRectMin: vec2, clipRectMax: vec2, intersectWithCurrentClipRect: boolean): void;
    popClipRect(): void;
    setItemDefaultFocus(): void;
    setKeyboardFocusHere(offset?: number): void;
    isItemHovered(flags?: HoveredFlags): boolean;
    isItemActive(): boolean;
    isItemFocused(): boolean;
    isItemClicked(mouseButton?: MouseButton): boolean;
    isItemVisible(): boolean;
    isItemEdited(): boolean;
    isItemActivated(): boolean;
    isItemDeactivated(): boolean;
    isItemDeactivatedAfterEdit(): boolean;
    isItemToggledOpen(): boolean;
    isAnyItemHovered(): boolean;
    isAnyItemActive(): boolean;
    isAnyItemFocused(): boolean;
    getItemRectMin(): vec2;
    getItemRectMax(): vec2;
    getItemRectSize(): vec2;
    setItemAllowOverlap(): void;
    isRectVisible(size: vec2): boolean;
    isRectVisible(rectMin: vec2, rectMax: vec2): boolean;
    getTime(): number;
    getFrameCount(): number;
    getBackgroundDrawList(): DrawListRef;
    getBackgroundDrawList(viewport: ViewportRef): DrawListRef;
    getForegroundDrawList(): DrawListRef;
    getForegroundDrawList(viewport: ViewportRef): DrawListRef;
    getStyleColorName(idx: Col): string;
    calcListClipping(itemsCount: number, itemsHeight: number): vec2;
    beginChildFrame(id: number, size: vec2, flags?: WindowFlags): boolean;
    endChildFrame(): void;
    calcTextSize(text: string, hideTextAfterDoubleHash?: boolean, wrapWidth?: number): vec2;
    colorConvertRGBtoHSV(color: vec4): vec4;
    colorConvertHSVtoRGB(color: vec4): vec4;
    isKeyDown(keyIndex: Scancode): boolean;
    isKeyPressed(keyIndex: Scancode, repeat?: boolean): boolean;
    isKeyReleased(keyIndex: Scancode): boolean;
    getKeyPressedAmount(keyIndex: Scancode, repeatDelay: number, rate: number): number;
    captureKeyboardFromApp(wantCaptureKeyboardValue: boolean): void;
    isMouseDown(button: MouseButton): boolean;
    isMouseClicked(button: MouseButton, repeat?: boolean): boolean;
    isMouseReleased(button: MouseButton): boolean;
    isMouseDoubleClicked(button: MouseButton): boolean;
    isMouseHoveringRect(rMin: vec2, rMax: vec2, clip?: boolean): boolean;
    isMousePosValid(mousePos?: vec2): boolean;
    isAnyMouseDown(): boolean;
    getMousePos(): vec2;
    getMousePosOnOpeningCurrentPopup(): vec2;
    isMouseDragging(button: MouseButton, lockThreshold?: number): boolean;
    getMouseDragDelta(button?: MouseButton, lockThreshold?: number): vec2;
    resetMouseDragDelta(button?: MouseButton): void;
    getMouseCursor(): MouseCursor;
    setMouseCursor(cursorType: MouseCursor): void;
    captureMouseFromApp(wantCaptureMouseValue?: boolean): void;
    getClipboardText(): string;
    setClipboardText(text: string): void;
    loadIniSettingsFromDisk(iniFilename: string): void;
    loadIniSettingsFromMemory(iniData: Buffer): void;
    saveIniSettingsToDisk(iniFilename: string): void;
    saveIniSettingsToMemory(): Buffer;
    getMainViewport(): ViewportRef;
    findViewportById(id: number): ViewportRef;
    pushItemDisabled(disabled: boolean): void;
    popItemDisabled(): void;
}
