import path from 'path';

let ML_BASE_RESOLVE_PATH: string = path.resolve(process.cwd());

export function ML_SET_BASE_PATH(base: string){
    ML_BASE_RESOLVE_PATH = path.resolve(base);
}

function join(...parts: string[]): string {
    let p: string[] = [ML_BASE_RESOLVE_PATH];
    p.push(...parts);
    return path.join(...parts);
}

function resolve(...parts: string[]): string {
    return path.resolve(join(...parts));
}

function resolve_classic(...parts: string[]){
    return path.resolve(...parts);
}

function join_classic(...parts: string[]){
    return path.join(...parts);
}

function parse(p: string){
    return path.parse(p);
}

function relative(from: string, to: string){
    return path.relative(from, to);
}

export default {join, resolve, resolve_classic, join_classic, parse, relative};