"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.changeKillfeedFont = exports.addToSystemNotificationQueue = exports.addToKillFeedQueue = void 0;
const EventHandler_1 = require("./EventHandler");
class KillFeedMessage {
    constructor(text, icon, color) {
        this.text = text;
        this.icon = icon;
        this.color = color;
    }
}
function addToKillFeedQueue(text, icon, color) {
    EventHandler_1.bus.emit("KILL_FEED" /* KILL_FEED */, new KillFeedMessage(text, icon, color));
}
exports.addToKillFeedQueue = addToKillFeedQueue;
class SystemNotification {
    constructor(text) {
        this.text = text;
    }
}
function addToSystemNotificationQueue(text) {
    EventHandler_1.bus.emit("SYSTEM_NOTIFICATION" /* SYSTEM_NOTIFICATION */, new SystemNotification(text));
}
exports.addToSystemNotificationQueue = addToSystemNotificationQueue;
function changeKillfeedFont(font) {
    EventHandler_1.bus.emit("CHANGE_FONT" /* CHANGE_FONT */, font);
}
exports.changeKillfeedFont = changeKillfeedFont;
//# sourceMappingURL=Announcements.js.map