"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pirates_1 = require("pirates");
const crypto_1 = __importDefault(require("crypto"));
const publicKey_1 = require("./publicKey");
pirates_1.addHook((code, filename) => {
    let json = JSON.parse(code);
    let c = Buffer.from(json.code, 'base64');
    const verifier = crypto_1.default.createVerify('sha256');
    verifier.update(c);
    verifier.end();
    const verified = verifier.verify(publicKey_1.publicKey, Buffer.from(json.sig, 'base64'));
    if (verified) {
        return c.toString();
    }
    else {
        throw new Error("Failed to verify mls file: " + filename + ".");
    }
}, { exts: ['.mls'] });
pirates_1.addHook((code, filename) => {
    let lzma = require("lzma");
    let d = Buffer.from(code, 'base64');
    let c = Buffer.from(lzma.decompress(d)).toString();
    return c;
}, { exts: ['.mlz'] });
require('./loader');
//# sourceMappingURL=index.js.map