/// <reference types="node" />
import { IRomMemory } from './IRomMemory';
export declare class RomHeap {
    free_head: number;
    free_tail: number;
    used_head: number;
    start: number;
    end: number;
    size: number;
    emulator: IRomMemory;
    rom: Buffer;
    constructor(rom: Buffer, emulator: IRomMemory, start?: number, size?: number);
    malloc(size: number): number;
    free(address: number): void;
    realloc(address: number, size: number): number;
    wipe(): void;
    get_free(): number;
    get_largest_free(): number;
}
