export declare const enum Button {
    DPadRight = 0,
    DPadLeft = 1,
    DPadDown = 2,
    DPadUp = 3,
    Start = 4,
    Z = 5,
    B = 6,
    A = 7,
    CRight = 8,
    CLeft = 9,
    CDown = 10,
    CUp = 11,
    R = 12,
    L = 13
}
export declare const enum Axis {
    X = 0,
    Y = 1
}
export declare const enum FilterFlags {
    None = 0,
    DPadRight = 1,
    DPadLeft = 2,
    DPadDown = 4,
    DPadUp = 8,
    Start = 16,
    Z = 32,
    B = 64,
    A = 128,
    CRight = 256,
    CLeft = 512,
    CDown = 1024,
    CUp = 2048,
    R = 4096,
    L = 8192,
    XAxis = 16711680,
    YAxis = -16777216,
    All = 4294967295
}
export interface Input {
    getAxis(cont: number, axis: Axis): number;
    setAxis(cont: number, axis: Axis, value: number): void;
    setAxisVi(cont: number, axis: Axis, value: number): void;
    getButton(cont: number, button: Button): boolean;
    getButtonDown(cont: number, button: Button): boolean;
    getButtonUp(cont: number, button: Button): boolean;
    setButton(cont: number, button: Button, pressed: boolean): boolean;
    setButtonDown(cont: number, button: Button): boolean;
    getPluginFilter(cont: number): FilterFlags;
    setPluginFilter(cont: number, filter: FilterFlags): void;
}
