"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupParentReference = exports.ParentReference = exports.setupSidedProxy = exports.SidedProxy = exports.ProxySideContainer = void 0;
const path_1 = __importDefault(require("path"));
function custom_dummy() {
    return true;
}
class ProxySideContainer {
    constructor(side, backing, core, custom) {
        this.side = side;
        this.backing = backing;
        this.core = core;
        this.custom = custom;
        if (this.custom === undefined) {
            this.custom = custom_dummy;
        }
    }
}
exports.ProxySideContainer = ProxySideContainer;
function SidedProxy(side, inst, core, custom) {
    return function (target, propertyKey) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.sidedproxies === undefined) {
            target.ModLoader['sidedproxies'] = new Map();
        }
        target.ModLoader.sidedproxies.set(new ProxySideContainer(side, inst, core, custom), propertyKey);
    };
}
exports.SidedProxy = SidedProxy;
function setupSidedProxy(instance, isClient, isServer, core) {
    let p = Object.getPrototypeOf(instance);
    let arr = [];
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return arr;
        }
        if (p.ModLoader.hasOwnProperty('sidedproxies')) {
            p.ModLoader.sidedproxies.forEach(function (value, key) {
                if (key.core !== undefined) {
                    if (key.core !== '*') {
                        if (key.core !== core)
                            return;
                    }
                }
                if (!key.custom())
                    return;
                if ((isClient && key.side === 0 /* CLIENT */) || key.side === 2 /* UNIVERSAL */) {
                    if (typeof (key.backing) === 'string') {
                        let c;
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".js")).default;
                            }
                        }
                        catch (err) {
                        }
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".mls")).default;
                            }
                        }
                        catch (err) { }
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".mlz")).default;
                            }
                        }
                        catch (err) { }
                        instance[value] = new c();
                    }
                    else {
                        instance[value] = new key.backing();
                    }
                    arr.push(instance[value]);
                }
                else if (isServer && key.side === 1 /* SERVER */) {
                    if (typeof (key.backing) === 'string') {
                        let c;
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".js")).default;
                            }
                        }
                        catch (err) {
                        }
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".mls")).default;
                            }
                        }
                        catch (err) { }
                        try {
                            if (c === undefined) {
                                c = require(path_1.default.resolve(path_1.default.parse(key.backing).dir, path_1.default.parse(key.backing).name + ".mlz")).default;
                            }
                        }
                        catch (err) { }
                        instance[value] = new c();
                    }
                    else {
                        instance[value] = new key.backing();
                    }
                    arr.push(instance[value]);
                }
            });
        }
    }
    return arr;
}
exports.setupSidedProxy = setupSidedProxy;
function ParentReference() {
    return function (target, propertyKey) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.ParentReference === undefined) {
            target.ModLoader['ParentReference'] = new Map();
        }
        target.ModLoader.ParentReference.set(propertyKey, propertyKey);
    };
}
exports.ParentReference = ParentReference;
function setupParentReference(instance, parent) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('ParentReference')) {
            p.ModLoader.ParentReference.forEach(function (value, key) {
                instance[key] = parent;
            });
        }
    }
}
exports.setupParentReference = setupParentReference;
//# sourceMappingURL=SidedProxy.js.map