"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utilities_1 = require("../utilities");
var not_1 = require("../bits/not");
var read_1 = require("./read");
/**
 * Converts a section of a buffer to a signed integer.
 *
 * @example
 * // buffer 11110110
 * readUInt(buffer, 3, 5) => -10
 *
 * @param {Buffer} buffer the buffer to extract information from
 * @param {Number} length the length of the signed integer (in bits)
 * @param {Number} offset where to start (in bits)
 * @return {Number}
 */
exports.default = (function (buffer, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (length === void 0) { length = 8; }
    var bits = read_1.default(buffer, offset, length);
    if (bits[0] === 0) {
        var result = 0;
        for (var i = 0; i < length; i++)
            if (bits[i])
                result += utilities_1.p2[length - i - 1];
        return result;
    }
    else {
        var result = -1;
        var inverted = not_1.default(bits);
        for (var i = 0; i < length; i++)
            if (inverted[i])
                result -= utilities_1.p2[length - i - 1];
        return result;
    }
});
