"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Vector3 {
    constructor(_x = 0, _y = 0, _z = 0) {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        _x = isNaN(_x) ? 0 : _x;
        _y = isNaN(_y) ? 0 : _y;
        _z = isNaN(_z) ? 0 : _z;
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }
    plus(rhs) {
        return new Vector3(this.x + rhs.x, this.y + rhs.y, this.z + rhs.z);
    }
    minus(rhs) {
        return new Vector3(this.x - rhs.x, this.y - rhs.y, this.z - rhs.z);
    }
    multiply(rhs) {
        return new Vector3(this.x * rhs.x, this.y * rhs.y, this.z * rhs.z);
    }
    multiplyN(rhs) {
        return new Vector3(this.x * rhs, this.y * rhs, this.z * rhs);
    }
    divide(rhs) {
        return new Vector3(this.x / rhs.x, this.y / rhs.y, this.z / rhs.z);
    }
    divideN(rhs) {
        return new Vector3(this.x / rhs, this.y / rhs, this.z / rhs);
    }
    magnitude() {
        return Math.pow(this.x * this.x + this.y * this.y + this.z * this.z, 0.5);
    }
    inverse() {
        return this.multiplyN(-1);
    }
    dot(rhs) {
        return this.x * rhs.x
            + this.y * rhs.y
            + this.z * rhs.z;
    }
    cross(rhs) {
        return new Vector3(this.y * rhs.z - rhs.y * this.z, this.z * rhs.x - rhs.z * this.x, this.x * rhs.y - rhs.x * this.y);
    }
    normalized() {
        let mag = this.magnitude();
        if (mag == 0)
            return new Vector3();
        return this.divideN(mag);
    }
    toString() {
        return "(" + this.x.toString() + ", " + this.y.toString() + ", " + this.z.toString() + ")";
    }
    isNaN() {
        return !(this.x === this.x && this.y === this.y && this.z === this.z);
    }
    getNaNs() {
        return (!(this.x === this.x) ? "x " : "") + (!(this.y === this.y) ? "y " : "") + (!(this.z === this.z) ? "z" : "");
    }
}
exports.default = Vector3;
//# sourceMappingURL=Vector3.js.map