export declare const enum Keymod {
    None = 0,
    LeftShift = 1,
    RightShift = 2,
    LeftCtrl = 64,
    RightCtrl = 128,
    LeftAlt = 256,
    RightAlt = 512,
    LeftGui = 1024,
    RightGui = 2048,
    Num = 4096,
    Caps = 8192,
    Mode = 16384,
    Ctrl = 192,
    Shift = 3,
    Alt = 768,
    Gui = 3072
}
export declare const enum Keycode {
    Unknown = 0,
    Return = 13,
    Escape = 27,
    Backspace = 8,
    Tab = 9,
    Space = 32,
    Exclaim = 33,
    QuoteDbl = 34,
    Hash = 35,
    Percent = 37,
    Dollar = 36,
    Ampersand = 38,
    Quote = 39,
    LeftParen = 40,
    RightParen = 41,
    Asterisk = 42,
    Plus = 43,
    Comma = 44,
    Minus = 45,
    Period = 46,
    Slash = 47,
    Num0 = 48,
    Num1 = 49,
    Num2 = 50,
    Num3 = 51,
    Num4 = 52,
    Num5 = 53,
    Num6 = 54,
    Num7 = 55,
    Num8 = 56,
    Num9 = 57,
    Colon = 58,
    Semicolon = 59,
    Less = 60,
    Equals = 61,
    Greater = 62,
    Question = 63,
    At = 64,
    LeftBracket = 91,
    Backslash = 92,
    RightBracket = 93,
    Caret = 94,
    Underscore = 95,
    BackQuote = 96,
    A = 97,
    B = 98,
    C = 99,
    D = 100,
    E = 101,
    F = 102,
    G = 103,
    H = 104,
    I = 105,
    J = 106,
    K = 107,
    L = 108,
    M = 109,
    N = 110,
    O = 111,
    P = 112,
    Q = 113,
    R = 114,
    S = 115,
    T = 116,
    U = 117,
    V = 118,
    W = 119,
    X = 120,
    Y = 121,
    Z = 122,
    CapsLock = 1073741881,
    F1 = 1073741882,
    F2 = 1073741883,
    F3 = 1073741884,
    F4 = 1073741885,
    F5 = 1073741886,
    F6 = 1073741887,
    F7 = 1073741888,
    F8 = 1073741889,
    F9 = 1073741890,
    F10 = 1073741891,
    F11 = 1073741892,
    F12 = 1073741893,
    PrintScreen = 1073741894,
    ScrollLock = 1073741895,
    Pause = 1073741896,
    Insert = 1073741897,
    Home = 1073741898,
    PageUp = 1073741899,
    Delete = 127,
    End = 1073741901,
    PageDown = 1073741902,
    Right = 1073741903,
    Left = 1073741904,
    Down = 1073741905,
    Up = 1073741906,
    NumLockClear = 1073741907,
    PadDivide = 1073741908,
    PadMultiply = 1073741909,
    PadMinus = 1073741910,
    PadPlus = 1073741911,
    PadEnter = 1073741912,
    Pad1 = 1073741913,
    Pad2 = 1073741914,
    Pad3 = 1073741915,
    Pad4 = 1073741916,
    Pad5 = 1073741917,
    Pad6 = 1073741918,
    Pad7 = 1073741919,
    Pad8 = 1073741920,
    Pad9 = 1073741921,
    Pad0 = 1073741922,
    PadPeriod = 1073741923,
    Application = 1073741925,
    Power = 1073741926,
    PadEquals = 1073741927,
    F13 = 1073741928,
    F14 = 1073741929,
    F15 = 1073741930,
    F16 = 1073741931,
    F17 = 1073741932,
    F18 = 1073741933,
    F19 = 1073741934,
    F20 = 1073741935,
    F21 = 1073741936,
    F22 = 1073741937,
    F23 = 1073741938,
    F24 = 1073741939,
    Execute = 1073741940,
    Help = 1073741941,
    Menu = 1073741942,
    Select = 1073741943,
    Stop = 1073741944,
    Again = 1073741945,
    Undo = 1073741946,
    Cut = 1073741947,
    Copy = 1073741948,
    Paste = 1073741949,
    Find = 1073741950,
    Mute = 1073741951,
    VolumeUp = 1073741952,
    VolumeDown = 1073741953,
    PadComma = 1073741957,
    PadEqualsAS400 = 1073741958,
    AltErase = 1073741977,
    SysReg = 1073741978,
    Cancel = 1073741979,
    Clear = 1073741980,
    Prior = 1073741981,
    Return2 = 1073741982,
    Separato = 1073741983,
    Out = 1073741984,
    Oper = 1073741985,
    ClearAgain = 1073741986,
    CrSel = 1073741987,
    ExSel = 1073741988,
    Pad00 = 1073742000,
    Pad000 = 1073742001,
    ThousandsSeparator = 1073742002,
    DecimalSeparator = 1073742003,
    CurrencyUnit = 1073742004,
    CurrencySubUnit = 1073742005,
    PadLeftParen = 1073742006,
    PadRightParen = 1073742007,
    PadLeftBrace = 1073742008,
    PadRightBrace = 1073742009,
    PadTab = 1073742010,
    PadBackspace = 1073742011,
    PadA = 1073742012,
    PadB = 1073742013,
    PadC = 1073742014,
    PadD = 1073742015,
    PadE = 1073742016,
    PadF = 1073742017,
    PadXor = 1073742018,
    PadPower = 1073742019,
    PadPercent = 1073742020,
    PadLess = 1073742021,
    PadGreater = 1073742022,
    PadAmpersand = 1073742023,
    PadDblAmpersand = 1073742024,
    PadVerticalBar = 1073742025,
    PadDblVerticalBar = 1073742026,
    PadColon = 1073742027,
    PadHash = 1073742028,
    PadSpace = 1073742029,
    PadAt = 1073742030,
    PadExclam = 1073742031,
    PadMemStore = 1073742032,
    PadMemRecall = 1073742033,
    PadMemClear = 1073742034,
    PadMemAdd = 1073742035,
    PadMemSubtract = 1073742036,
    PadMemMultiply = 1073742037,
    PadMemDivide = 1073742038,
    PadPlusMinus = 1073742039,
    PadClear = 1073742040,
    PadClearEntry = 1073742041,
    PadBinary = 1073742042,
    PadOctal = 1073742043,
    PadDecimal = 1073742044,
    PadHexadecimal = 1073742045,
    LeftCtrl = 1073742048,
    LeftShift = 1073742049,
    LeftAlt = 1073742050,
    LeftGui = 1073742051,
    RightCtrl = 1073742052,
    RightShift = 1073742053,
    RightAlt = 1073742054,
    RightGui = 1073742055,
    Mode = 1073742081,
    AudioNext = 1073742082,
    AudioPrev = 1073742083,
    AudioStop = 1073742084,
    AudioPlay = 1073742085,
    AudioMute = 1073742086,
    MediaSelect = 1073742087,
    Www = 1073742088,
    Mail = 1073742089,
    Calculator = 1073742090,
    Computer = 1073742091,
    ACSearch = 1073742092,
    ACHome = 1073742093,
    ACBack = 1073742094,
    ACForward = 1073742095,
    ACStop = 1073742096,
    ACRefresh = 1073742097,
    ACBookmarks = 1073742098,
    BrightnessDown = 1073742099,
    BrightnessUp = 1073742100,
    DisplaySwitch = 1073742101,
    KbdIllumToggle = 1073742102,
    KbdIllumDown = 1073742103,
    KbdIllumUp = 1073742104,
    Eject = 1073742105,
    Sleep = 1073742106,
    App1 = 1073742107,
    App2 = 1073742108,
    AudioRewind = 1073742109,
    AudioFastForward = 1073742110
}
export declare const enum Scancode {
    Unknown = 0,
    A = 4,
    B = 5,
    C = 6,
    D = 7,
    E = 8,
    F = 9,
    G = 10,
    H = 11,
    I = 12,
    J = 13,
    K = 14,
    L = 15,
    M = 16,
    N = 17,
    O = 18,
    P = 19,
    Q = 20,
    R = 21,
    S = 22,
    T = 23,
    U = 24,
    V = 25,
    W = 26,
    X = 27,
    Y = 28,
    Z = 29,
    Num1 = 30,
    Num2 = 31,
    Num3 = 32,
    Num4 = 33,
    Num5 = 34,
    Num6 = 35,
    Num7 = 36,
    Num8 = 37,
    Num9 = 38,
    Num0 = 39,
    Return = 40,
    Escape = 41,
    Backspace = 42,
    Tab = 43,
    Space = 44,
    Minus = 45,
    Equals = 46,
    LeftBracket = 47,
    RightBracket = 48,
    Backslash = 49,
    NonUsHash = 50,
    Semicolon = 51,
    Apostrophe = 52,
    Grave = 53,
    Comma = 54,
    Period = 55,
    Slash = 56,
    CapsLock = 57,
    F1 = 58,
    F2 = 59,
    F3 = 60,
    F4 = 61,
    F5 = 62,
    F6 = 63,
    F7 = 64,
    F8 = 65,
    F9 = 66,
    F10 = 67,
    F11 = 68,
    F12 = 69,
    PrintScreen = 70,
    ScrollLock = 71,
    Pause = 72,
    Insert = 73,
    Home = 74,
    PageUp = 75,
    Delete = 76,
    End = 77,
    PageDown = 78,
    Right = 79,
    Left = 80,
    Down = 81,
    Up = 82,
    NumLockClear = 83,
    PadDivide = 84,
    PadMultiply = 85,
    PadMinus = 86,
    PadPlus = 87,
    PadEnter = 88,
    Pad1 = 89,
    Pad2 = 90,
    Pad3 = 91,
    Pad4 = 92,
    Pad5 = 93,
    Pad6 = 94,
    Pad7 = 95,
    Pad8 = 96,
    Pad9 = 97,
    Pad0 = 98,
    PadPeriod = 99,
    NonUsBackslash = 100,
    Application = 101,
    Power = 102,
    PadEquals = 103,
    F13 = 104,
    F14 = 105,
    F15 = 106,
    F16 = 107,
    F17 = 108,
    F18 = 109,
    F19 = 110,
    F20 = 111,
    F21 = 112,
    F22 = 113,
    F23 = 114,
    F24 = 115,
    Execute = 116,
    Help = 117,
    Menu = 118,
    Select = 119,
    Stop = 120,
    Again = 121,
    Undo = 122,
    Cut = 123,
    Copy = 124,
    Paste = 125,
    Find = 126,
    Mute = 127,
    VolumeUp = 128,
    VolumeDown = 129,
    LockingCapsLock = 130,
    LockingNumLock = 131,
    LockingScrollLock = 132,
    PadComma = 133,
    PadEqualsAS400 = 134,
    International1 = 135,
    International2 = 136,
    International3 = 137,
    International4 = 138,
    International5 = 139,
    International6 = 140,
    International7 = 141,
    International8 = 142,
    International9 = 143,
    Lang1 = 144,
    Lang2 = 145,
    Lang3 = 146,
    Lang4 = 147,
    Lang5 = 148,
    Lang6 = 149,
    Lang7 = 150,
    Lang8 = 151,
    Lang9 = 152,
    AltErase = 153,
    SysReq = 154,
    Cancel = 155,
    Clear = 156,
    Prior = 157,
    Return2 = 158,
    Separator = 159,
    Out = 160,
    Oper = 161,
    ClearAgain = 162,
    CrSel = 163,
    ExSel = 164,
    Pad00 = 176,
    Pad000 = 177,
    ThousandsSeparator = 178,
    DecimalSeparator = 179,
    CurrencyUnit = 180,
    CurrencySubUnit = 181,
    PadLeftParen = 182,
    PadRightParen = 183,
    PadLeftBrace = 184,
    PadRightBrace = 185,
    PadTab = 186,
    PadBackspace = 187,
    PadA = 188,
    PadB = 189,
    PadC = 190,
    PadD = 191,
    PadE = 192,
    PadF = 193,
    PadXor = 194,
    PadPower = 195,
    PadPercent = 196,
    PadLess = 197,
    PadGreater = 198,
    PadAmpersand = 199,
    PadDblAmpersand = 200,
    PadVerticalBar = 201,
    PadDblVerticalBar = 202,
    PadColon = 203,
    PadHash = 204,
    PadSpace = 205,
    PadAt = 206,
    PadExclam = 207,
    PadMemStore = 208,
    PadMemRecall = 209,
    PadMemClear = 210,
    PadMemAdd = 211,
    PadMemSubtract = 212,
    PadMemMultiply = 213,
    PadMemDivide = 214,
    PadPlusMinux = 215,
    PadClear = 216,
    PadClearEntry = 217,
    PadBinary = 218,
    PadOctal = 219,
    PadDecimal = 220,
    PadHexadecimal = 221,
    LeftCtrl = 224,
    LeftShift = 225,
    LeftAlt = 226,
    LeftGui = 227,
    RightCtrl = 228,
    RightShift = 229,
    RightAlt = 230,
    RightGui = 231,
    Mode = 257,
    AudioNext = 258,
    AudioPrev = 259,
    AudioStop = 260,
    AudioPlay = 261,
    AudioMute = 262,
    MediaSelect = 263,
    Www = 264,
    Mail = 265,
    Calculator = 266,
    Computer = 267,
    ACSearch = 268,
    ACHome = 269,
    ACBack = 270,
    ACForward = 271,
    ACStop = 272,
    ACRefresh = 273,
    ACBookmarks = 274,
    BrightnessDown = 275,
    BrightnessUp = 276,
    DisplaySwitch = 277,
    KbdIllumToggle = 278,
    KbdIllumDown = 279,
    KbdIllumUp = 280,
    Eject = 281,
    Sleep = 282,
    App1 = 283,
    App2 = 284,
    AudioRewind = 285,
    AudioFastForward = 286
}
export interface Keybd {
    getKeyFromName(name: string): Keycode;
    getKeyFromScancode(scancode: Scancode): Keycode;
    getKeyName(key: Keycode): string;
    getKeyState(scancode: Scancode): boolean;
    getModState(): Keymod;
    getScancodeFromKey(key: Keycode): Scancode;
    getScancodeFromName(name: string): Scancode;
    getScancodeName(scancode: Scancode): string;
}
