"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupLifecycle_IPlugin = exports.setupLifecycle = exports.onCreateResources = exports.onViUpdate = exports.onPostTick = exports.onTick = exports.Postinit = exports.Init = exports.Preinit = exports.lifecyclebus = exports.LifecycleEventBus = void 0;
const events_1 = require("events");
class LifecycleEventBus extends events_1.EventEmitter {
}
exports.LifecycleEventBus = LifecycleEventBus;
exports.lifecyclebus = new LifecycleEventBus();
function Preinit() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.Preinit === undefined) {
            target.ModLoader.Lifecycle['Preinit'] = new Map();
        }
        target.ModLoader.Lifecycle.Preinit.set("Preinit", propertyKey);
    };
}
exports.Preinit = Preinit;
function Init() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.Init === undefined) {
            target.ModLoader.Lifecycle['Init'] = new Map();
        }
        target.ModLoader.Lifecycle.Init.set("Init", propertyKey);
    };
}
exports.Init = Init;
function Postinit() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.Postinit === undefined) {
            target.ModLoader.Lifecycle['Postinit'] = new Map();
        }
        target.ModLoader.Lifecycle.Postinit.set("Postinit", propertyKey);
    };
}
exports.Postinit = Postinit;
function onTick() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.onTick === undefined) {
            target.ModLoader.Lifecycle['onTick'] = new Map();
        }
        target.ModLoader.Lifecycle.onTick.set("onTick", propertyKey);
    };
}
exports.onTick = onTick;
function onPostTick() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.onPostTick === undefined) {
            target.ModLoader.Lifecycle['onPostTick'] = new Map();
        }
        target.ModLoader.Lifecycle.onPostTick.set("onPostTick", propertyKey);
    };
}
exports.onPostTick = onPostTick;
// #ifdef HAS_IMGUI
function onViUpdate() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.onViUpdate === undefined) {
            target.ModLoader.Lifecycle['onViUpdate'] = new Map();
        }
        target.ModLoader.Lifecycle.onViUpdate.set("onViUpdate", propertyKey);
    };
}
exports.onViUpdate = onViUpdate;
function onCreateResources() {
    return function (target, propertyKey, descriptor) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.Lifecycle === undefined) {
            target.ModLoader['Lifecycle'] = {};
        }
        if (target.ModLoader.Lifecycle.onCreateResources === undefined) {
            target.ModLoader.Lifecycle['onCreateResources'] = new Map();
        }
        target.ModLoader.Lifecycle.onCreateResources.set("onCreateResources", propertyKey);
    };
}
exports.onCreateResources = onCreateResources;
// #endif
function setupLifecycle(instance) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('Lifecycle')) {
            if (p.ModLoader.Lifecycle.hasOwnProperty("Preinit")) {
                p.ModLoader.Lifecycle.Preinit.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("preinit" /* PREINIT */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("Init")) {
                p.ModLoader.Lifecycle.Init.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("init" /* INIT */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("Postinit")) {
                p.ModLoader.Lifecycle.Postinit.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("postinit" /* POSTINIT */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("onTick")) {
                p.ModLoader.Lifecycle.onTick.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("ontick" /* ONTICK */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("onPostTick")) {
                p.ModLoader.Lifecycle.onPostTick.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("onposttick" /* ONPOSTTICK */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("onViUpdate")) {
                p.ModLoader.Lifecycle.onViUpdate.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("onviupdate" /* ONVIUPDATE */, a);
                });
            }
            if (p.ModLoader.Lifecycle.hasOwnProperty("onCreateResources")) {
                p.ModLoader.Lifecycle.onCreateResources.forEach(function (value, key) {
                    let a = instance[value].bind(instance);
                    exports.lifecyclebus.emit("oncreateresources" /* ONCREATERESOURCES */, a);
                });
            }
        }
    }
}
exports.setupLifecycle = setupLifecycle;
function setupLifecycle_IPlugin(instance) {
    // Wrapper for IPlugin.
    try {
        let old_pre = instance['preinit'].bind(instance);
        exports.lifecyclebus.emit("preinit" /* PREINIT */, old_pre);
    }
    catch (err) {
    }
    try {
        let old_init = instance['init'].bind(instance);
        exports.lifecyclebus.emit("init" /* INIT */, old_init);
    }
    catch (err) {
    }
    try {
        let old_post = instance['postinit'].bind(instance);
        exports.lifecyclebus.emit("postinit" /* POSTINIT */, old_post);
    }
    catch (err) {
    }
    try {
        let old_tick = instance['onTick'].bind(instance);
        exports.lifecyclebus.emit("ontick" /* ONTICK */, old_tick);
    }
    catch (err) {
    }
}
exports.setupLifecycle_IPlugin = setupLifecycle_IPlugin;
//# sourceMappingURL=PluginLifecycle.js.map