"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupMLInjects = exports.ModLoaderAPIInject = void 0;
function ModLoaderAPIInject() {
    return function (target, key) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.ModLoaderAPIInject === undefined) {
            target.ModLoader['ModLoaderAPIInject'] = {};
        }
        if (target.ModLoader.ModLoaderAPIInject.Targets === undefined) {
            target.ModLoader.ModLoaderAPIInject['Targets'] = new Map();
        }
        target.ModLoader.ModLoaderAPIInject.Targets.set(key, "yes");
    };
}
exports.ModLoaderAPIInject = ModLoaderAPIInject;
function setupMLInjects(instance, api) {
    let p = Object.getPrototypeOf(instance);
    if (p.hasOwnProperty('ModLoader')) {
        if (p.ModLoader.hasOwnProperty("hasBeenProcessed")) {
            return;
        }
        if (p.ModLoader.hasOwnProperty('ModLoaderAPIInject')) {
            if (p.ModLoader.ModLoaderAPIInject.hasOwnProperty("Targets")) {
                p.ModLoader.ModLoaderAPIInject.Targets.forEach((value, key) => {
                    instance[key] = api;
                });
            }
        }
    }
}
exports.setupMLInjects = setupMLInjects;
//# sourceMappingURL=ModLoaderAPIInjector.js.map