"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DependencyInjection = void 0;
const child_process_1 = __importDefault(require("child_process"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
let configured = false;
function DependencyInjection(name) {
    return (ctor) => {
        if (!fs_1.default.existsSync(`./moddeps/node_modules/${name}`)) {
            console.log(`Processing dependency decorator for ${name}...`);
            let out = child_process_1.default.execSync(`npm install --prefix ./moddeps ${name}`).toString().split('\n');
            out.shift();
            console.log(out.shift());
        }
        if (!configured) {
            process.env.NODE_PATH = `${path_1.default.resolve('./moddeps')}` + ':' + process.env.NODE_PATH;
            configured = true;
        }
    };
}
exports.DependencyInjection = DependencyInjection;
//# sourceMappingURL=DependencyInjection.js.map