"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packetHelper = exports.UDPPacket = exports.Packet = exports.NetworkPlayer = void 0;
class NetworkPlayer {
    constructor(nickname, uuid) {
        this.__nickname = () => { return ""; };
        this.data = {};
        this.nickname = nickname;
        this.uuid = uuid;
    }
    get nickname() {
        return this.__nickname();
    }
    set nickname(s) {
        let temp = s;
        if (temp.length > 20)
            temp = temp.substring(0, 20);
        if (temp.indexOf("\n") > -1)
            temp = temp.replace("\n", "");
        var nick = temp;
        this.__nickname = Object.freeze(() => {
            return nick;
        });
    }
    toJSON() {
        return { uuid: this.uuid, nickname: this.nickname, data: this.data };
    }
}
exports.NetworkPlayer = NetworkPlayer;
class Packet {
    constructor(packet_id, channel, lobby, forward = true) {
        this.packet_id = packet_id;
        this.channel = channel;
        this.forward = forward;
        this.socketType = 0 /* TCP */;
        this.lobby = lobby;
    }
}
exports.Packet = Packet;
class UDPPacket extends Packet {
    constructor(packet_id, channel, lobby, forward = true) {
        super(packet_id, channel, lobby, forward);
        this.socketType = 1 /* UDP */;
    }
}
exports.UDPPacket = UDPPacket;
class PacketHelper {
    cloneDestination(_old, _new) {
        _new.lobby = _old.lobby;
        _new.player = _old.player;
    }
}
exports.packetHelper = new PacketHelper();
//# sourceMappingURL=ModLoaderDefaultImpls.js.map