import { INetworkPlayer } from './NetworkHandler';
import { EventEmitter2 } from 'eventemitter2';
export declare class EventBus extends EventEmitter2 {
}
declare const bus: EventBus;
declare function EventHandler(key: string): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
declare function PrivateEventHandler(key: string): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
export declare class EventServerJoined {
    readonly player: INetworkPlayer;
    readonly lobby: string;
    constructor(player: INetworkPlayer, lobby: string);
}
export declare class EventOwnerChanged {
    readonly lobby: string;
    readonly owner: INetworkPlayer;
    constructor(lobby: string, owner: INetworkPlayer);
}
export declare class EventServerLeft extends EventServerJoined {
}
export declare enum EventsServer {
    ON_LOBBY_CREATE = "lobbyCreated_server",
    ON_LOBBY_JOIN = "lobbyJoin_server",
    ON_LOBBY_LEAVE = "lobbyLeave_server",
    ON_PLUGIN_READY = "pluginReady_server",
    ON_VERSION_CHECK = "versioncheck_server",
    ON_LOBBY_DATA = "lobbyData_server",
    ON_LOBBY_DESTROY = "lobbyDestroyed_Server",
    ON_LOBBY_OWNER_CHANGE = "lobbyOwnerChanged_server"
}
export declare enum EventsClient {
    ON_LOBBY_CREATE = "lobbyJoined_client",
    CONFIGURE_LOBBY = "configureLobby_client",
    ON_SERVER_CONNECTION = "onServerConnection_client",
    ON_PLAYER_LEAVE = "playerLeave_client",
    ON_PLAYER_JOIN = "playerJoin_client",
    ON_LOBBY_JOIN = "lobbyJoined_client",
    ON_PLUGIN_READY = "pluginReady_client",
    ON_INJECT_FINISHED = "plugins_injectFinished",
    ON_PAYLOAD_INJECTED = "plugins_OnPayloadInjected",
    ON_HEAP_READY = "ON_HEAP_READY",
    ON_HEAP_SETUP = "ON_HEAP_SETUP",
    ON_LOBBY_OWNER_CHANGE = "lobbyOwnerChanged_client"
}
export declare function setupEventHandlers(instance: any, _bus: EventBus): void;
export declare function setupPrivateEventHandlers(instance: any, _bus: EventBus): void;
export declare function markPrototypeProcessed(instance: any): void;
export { bus, EventHandler, PrivateEventHandler };
