import child_process from 'child_process';
import fs from 'fs';
import path from 'path';

let configured: boolean = false;

export function DependencyInjection(name: string) {
    return (ctor: Function) => {
        if (!fs.existsSync(`./moddeps/node_modules/${name}`)) {
            console.log(`Processing dependency decorator for ${name}...`);
            let out = child_process.execSync(`npm install --prefix ./moddeps ${name}`).toString().split('\n');
            out.shift();
            console.log(out.shift());
        }
        if (!configured) {
            process.env.NODE_PATH = `${path.resolve('./moddeps')}` + ':' + process.env.NODE_PATH;
            configured = true;
        }
    }
}
