"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const JSON_1 = require("./JSON");
const bitwise_1 = __importDefault(require("bitwise"));
class MonkeyPatch_rdramWriteBit8 extends JSON_1.MonkeyPatch {
    constructor(mupen) {
        super();
        this.mupen = mupen;
    }
    patch() {
        this.replacement = (addr, bitoffset, bit) => {
            let data = this.mupen.rdramRead8(addr);
            let bits = bitwise_1.default.byte.read(data);
            bits[bitoffset] = bit ? 1 : 0;
            data = bitwise_1.default.byte.write(bits);
            this.mupen.rdramWrite8(addr, data);
        };
        this.original = this.mupen.rdramWriteBit8;
        this.mupen['rdramWriteBit8'] = this.replacement;
    }
    unpatch() {
        this.mupen['rdramWriteBit8'] = this.original;
    }
}
exports.MonkeyPatch_rdramWriteBit8 = MonkeyPatch_rdramWriteBit8;
//# sourceMappingURL=Mupen.js.map