"use strict";
// So, JSON.stringify and JSON.parse completely fail at Buffers.
// Lets fix that in the most brute force way possible.
// MONKEY PATCH
Object.defineProperty(exports, "__esModule", { value: true });
const BJSON = require('buffer-json');
class MonkeyPatch {
}
exports.MonkeyPatch = MonkeyPatch;
class MonkeyPatch_Stringify extends MonkeyPatch {
    patch() {
        this.original = JSON.stringify;
        this.replacement = (value, replacer, space) => {
            if (replacer === undefined) {
                return this.original(value, BJSON.replacer, space);
            }
            else {
                return this.original(value, replacer, space);
            }
        };
        JSON['stringify'] = this.replacement;
    }
    unpatch() {
        JSON['stringify'] = this.original;
    }
}
exports.MonkeyPatch_Stringify = MonkeyPatch_Stringify;
class MonkeyPatch_Parse extends MonkeyPatch {
    patch() {
        this.original = JSON.parse;
        this.replacement = (text, reviver) => {
            if (reviver === undefined) {
                return this.original(text, BJSON.reviver);
            }
            else {
                return this.original(text, reviver);
            }
        };
        JSON['parse'] = this.replacement;
    }
    unpatch() {
        JSON['parse'] = this.original;
    }
}
exports.MonkeyPatch_Parse = MonkeyPatch_Parse;
//# sourceMappingURL=JSON.js.map