"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
let profiler = require('v8-profiler-next');
let gcprofiler = require('gc-profiler');
let nextMBThreshold = 0;
// For if you think you have a memory leak or just want to know what the hell the GC is doing.
function startProfiler() {
    setInterval(tickHeapDump, 500);
    gcprofiler.on('gc', function (info) {
        console.log(info);
    });
}
exports.startProfiler = startProfiler;
function tickHeapDump() {
    setImmediate(function () {
        heapDump();
    });
}
function heapDump() {
    let memMB = process.memoryUsage().rss / 1048576;
    console.log(memMB + '>' + nextMBThreshold);
    if (memMB > nextMBThreshold) {
        console.log('Current memory usage: %j', process.memoryUsage());
        nextMBThreshold += 50;
        let snap = profiler.takeSnapshot();
        saveHeapSnapshot(snap);
    }
}
function saveHeapSnapshot(snapshot) {
    snapshot.export(function (error, result) {
        if (error) {
            console.error(error);
            return;
        }
        fs_1.default.writeFileSync('./heap.dump', result);
        snapshot.delete();
    });
}
//# sourceMappingURL=profiler.js.map