"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const API = __importStar(require("modloader64_api/SM64/Imports"));
// ##################################################################
// ##  Sub-Classes
// ##################################################################
class SaveFile extends API.BufferObj {
    constructor(emu, profile_instance) {
        super(emu, profile_instance, 0x70);
    }
}
exports.SaveFile = SaveFile;
// ##################################################################
// ##  Primary-Classes
// ##################################################################
class Mario extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.instance = global.ModLoader['SM64:mario'];
        this.pos_x_addr = 0x20;
        this.pos_y_addr = 0x24;
        this.pos_z_addr = 0x28;
        this.rot_x_addr = 0x54;
        this.rot_y_addr = 0x58;
        this.rot_z_addr = 0x5c;
    }
    get exists() {
        return !(this.emulator.rdramRead32(this.instance) === 0x00000000);
    }
    get animation() {
        return Buffer.from([this.anim_frame, this.anim_id]);
    }
    set animation(val) {
        this.anim_frame = val[0];
        this.anim_id = val[1];
    }
    get anim_frame() {
        return 0;
    }
    set anim_frame(val) {
        return;
    }
    get anim_id() {
        return 0;
    }
    set anim_id(val) {
        return;
    }
    get position() {
        return Buffer.from([this.pos_x, this.pos_y, this.pos_z]);
    }
    set position(val) {
        this.pos_x = val[0];
        this.pos_y = val[1];
        this.pos_z = val[2];
    }
    get pos_x() {
        return this.emulator.rdramReadPtr32(this.instance, this.pos_x_addr);
    }
    set pos_x(val) {
        this.emulator.rdramWritePtr32(this.instance, this.pos_x_addr, val);
    }
    get pos_y() {
        return this.emulator.rdramReadPtr32(this.instance, this.pos_y_addr);
    }
    set pos_y(val) {
        this.emulator.rdramWritePtr32(this.instance, this.pos_y_addr, val);
    }
    get pos_z() {
        return this.emulator.rdramReadPtr32(this.instance, this.pos_z_addr);
    }
    set pos_z(val) {
        this.emulator.rdramWritePtr32(this.instance, this.pos_z_addr, val);
    }
    get rotation() {
        return Buffer.from([this.rot_x, this.rot_y, this.rot_z]);
    }
    set rotation(val) {
        this.rot_x = val[0];
        this.rot_y = val[1];
        this.rot_z = val[2];
    }
    get rot_x() {
        return this.emulator.rdramReadPtr32(this.instance, this.rot_x_addr);
    }
    set rot_x(val) {
        this.emulator.rdramWritePtr32(this.instance, this.rot_x_addr, val);
    }
    get rot_y() {
        return this.emulator.rdramReadPtr32(this.instance, this.rot_y_addr);
    }
    set rot_y(val) {
        this.emulator.rdramWritePtr32(this.instance, this.rot_y_addr, val);
    }
    get rot_z() {
        return this.emulator.rdramReadPtr32(this.instance, this.rot_z_addr);
    }
    set rot_z(val) {
        this.emulator.rdramWritePtr32(this.instance, this.rot_z_addr, val);
    }
    get cap() {
        return 0;
    }
    set cap(val) {
        return;
    }
}
exports.Mario = Mario;
class Runtime extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.cur_scene_addr = global.ModLoader['SM64:current_scene'];
        this.cur_prof_addr = global.ModLoader['SM64:current_profile'];
        this.star_count_addr = global.ModLoader['SM64:star_count'];
    }
    get_current_scene() {
        return this.emulator.rdramRead16(this.cur_scene_addr);
    }
    get_current_profile() {
        return this.emulator.rdramRead8(this.cur_prof_addr) - 1;
    }
    get star_count() {
        return this.emulator.rdramRead16(this.star_count_addr);
    }
    set star_count(val) {
        this.emulator.rdramWrite16(this.star_count_addr, val);
    }
}
exports.Runtime = Runtime;
class SuperMario64 {
    constructor() {
        this.header = 'SUPER MARIO 64';
        this.ModLoader = {};
        this.eventTicks = new Map();
    }
    preinit() {
        global.ModLoader['SM64:mario'] = 0x361158;
        // Save Context
        global.ModLoader['SM64:fileA'] = 0x207700;
        global.ModLoader['SM64:fileB'] = 0x207770;
        global.ModLoader['SM64:fileC'] = 0x2077e0;
        global.ModLoader['SM64:fileD'] = 0x207850;
        // Floating Data
        global.ModLoader['SM64:current_scene'] = 0x32ddf8;
        global.ModLoader['SM64:current_profile'] = 0x32ddf5;
        global.ModLoader['SM64:star_count'] = 0x33b21a;
    }
    init() { }
    postinit() {
        this.mario = new Mario(this.ModLoader.emulator);
        this.runtime = new Runtime(this.ModLoader.emulator);
        // Save Context
        this.save = [
            new SaveFile(this.ModLoader.emulator, global.ModLoader['SM64:fileA']),
            new SaveFile(this.ModLoader.emulator, global.ModLoader['SM64:fileB']),
            new SaveFile(this.ModLoader.emulator, global.ModLoader['SM64:fileC']),
            new SaveFile(this.ModLoader.emulator, global.ModLoader['SM64:fileD']),
        ];
    }
    onTick() {
        this.eventTicks.forEach((value, key) => {
            value();
        });
    }
}
exports.SuperMario64 = SuperMario64;
exports.default = SuperMario64;
//# sourceMappingURL=SuperMario64.js.map