/// <reference types="node" />
import { IModLoaderAPI, ICore } from 'modloader64_api/IModLoaderAPI';
import IMemory from 'modloader64_api/IMemory';
import * as API from 'modloader64_api/SM64/Imports';
export declare class SaveFile extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory, profile_instance: number);
}
export declare class Mario extends API.BaseObj implements API.IPlayer {
    private instance;
    private pos_x_addr;
    private pos_y_addr;
    private pos_z_addr;
    private rot_x_addr;
    private rot_y_addr;
    private rot_z_addr;
    readonly exists: boolean;
    animation: Buffer;
    anim_frame: number;
    anim_id: number;
    position: Buffer;
    pos_x: number;
    pos_y: number;
    pos_z: number;
    rotation: Buffer;
    rot_x: number;
    rot_y: number;
    rot_z: number;
    cap: number;
}
export declare class Runtime extends API.BaseObj implements API.IRuntime {
    private cur_scene_addr;
    private cur_prof_addr;
    private star_count_addr;
    get_current_scene(): number;
    get_current_profile(): number;
    star_count: number;
}
export declare class SuperMario64 implements ICore, API.ISM64Core {
    header: string;
    ModLoader: IModLoaderAPI;
    eventTicks: Map<string, Function>;
    mario: API.IPlayer;
    runtime: API.IRuntime;
    save: API.IBuffered[];
    preinit(): void;
    init(): void;
    postinit(): void;
    onTick(): void;
}
export default SuperMario64;
