"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const EventHandler_1 = require("modloader64_api/EventHandler");
const GameShark_1 = require("modloader64_api/GameShark");
const OOTAPI_1 = require("modloader64_api/OOT/OOTAPI");
const ActorManager_1 = require("./OOT/ActorManager");
const CommandBuffer_1 = require("./OOT/CommandBuffer");
const GlobalContext_1 = require("./OOT/GlobalContext");
const Link_1 = require("./OOT/Link");
const OotHelper_1 = require("./OOT/OotHelper");
const SaveContext_1 = require("./OOT/SaveContext");
const KeyManager_1 = require("./OOT/KeyManager");
var ROM_VERSIONS;
(function (ROM_VERSIONS) {
    ROM_VERSIONS[ROM_VERSIONS["N0"] = 0] = "N0";
    ROM_VERSIONS[ROM_VERSIONS["DEBUG"] = 15] = "DEBUG";
})(ROM_VERSIONS || (ROM_VERSIONS = {}));
class OcarinaofTime {
    constructor() {
        this.header = 'THE LEGEND OF ZELDA';
        this.payloads = new Array();
        this.eventTicks = new Map();
        // Client side variables
        this.isSaveLoaded = false;
        this.last_known_scene = -1;
        this.touching_loading_zone = false;
        this.frame_count_reset_scene = -1;
    }
    preinit() {
        this.ModLoader.logger.info('OOT VERSION: ' + ROM_VERSIONS[this.rom_header.revision] + '.');
        switch (this.rom_header.revision) {
            case ROM_VERSIONS.N0: {
                global.ModLoader['save_context'] = 0x11a5d0;
                global.ModLoader['global_context_pointer'] = 0x11f248;
                global.ModLoader['overlay_table'] = 0x0e8530;
                this.payloads.push(__dirname + '/OOT/pak/OcarinaofTime.pak');
                break;
            }
            case ROM_VERSIONS.DEBUG: {
                global.ModLoader['save_context'] = 0x15e660;
                global.ModLoader['global_context_pointer'] = 0x157da0;
                global.ModLoader['overlay_table'] = 0x1159b0;
            }
        }
    }
    init() {
        this.eventTicks.set('waitingForSaveload', () => {
            if (!this.isSaveLoaded && this.helper.isSceneNumberValid()) {
                EventHandler_1.bus.emit(OOTAPI_1.OotEvents.ON_SAVE_LOADED, {});
                this.isSaveLoaded = true;
                this.eventTicks.delete('waitingForSaveload');
            }
        });
        this.eventTicks.set('waitingForLoadingZoneTrigger', () => {
            if (this.helper.isLinkEnteringLoadingZone() &&
                !this.touching_loading_zone) {
                EventHandler_1.bus.emit(OOTAPI_1.OotEvents.ON_LOADING_ZONE, {});
                this.touching_loading_zone = true;
            }
        });
        this.eventTicks.set('waitingForFrameCount', () => {
            if (this.global.scene_framecount === 1 &&
                !this.helper.isTitleScreen() &&
                this.helper.isSceneNumberValid()) {
                let cur = this.global.scene;
                this.last_known_scene = cur;
                EventHandler_1.bus.emit(OOTAPI_1.OotEvents.ON_SCENE_CHANGE, this.last_known_scene);
                this.touching_loading_zone = false;
            }
        });
    }
    postinit() {
        this.global = new GlobalContext_1.GlobalContext(this.ModLoader.emulator);
        this.link = new Link_1.Link(this.ModLoader.emulator);
        this.save = new SaveContext_1.SaveContext(this.ModLoader.emulator, this.ModLoader.logger);
        this.helper = new OotHelper_1.OotHelper(this.save, this.global, this.link);
        this.commandBuffer = new CommandBuffer_1.CommandBuffer(this.ModLoader.emulator);
        this.actorManager = new ActorManager_1.ActorManager(this.ModLoader.emulator, this.ModLoader.logger, this.helper);
        this.keyManager = new KeyManager_1.KeyManager(this.ModLoader.emulator);
        this.eventTicks.set('tickingStuff', () => {
            this.commandBuffer.onTick();
            this.actorManager.onTick();
        });
    }
    onTick() {
        if (!this.helper.isTitleScreen()) {
            this.eventTicks.forEach((value, key) => {
                value();
            });
        }
    }
    onInject(evt) {
        let gameshark = new GameShark_1.GameShark(this.ModLoader.logger, this.ModLoader.emulator);
        for (let i = 0; i < this.payloads.length; i++) {
            gameshark.read(this.payloads[i]);
        }
    }
}
__decorate([
    EventHandler_1.EventHandler(EventHandler_1.EventsClient.ON_INJECT_FINISHED)
], OcarinaofTime.prototype, "onInject", null);
exports.OcarinaofTime = OcarinaofTime;
//# sourceMappingURL=OcarinaofTime.js.map