"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class SwordsEquipment extends JSONTemplate_1.JSONTemplate {
    constructor(emulator) {
        super();
        this.instance = global.ModLoader.save_context;
        this.equipment_addr = this.instance + 0x009c + 1;
        this.biggoron_flag_addr = this.instance + 0x003e;
        this.jsonFields = [
            'kokiriSword',
            'masterSword',
            'giantKnife',
            'biggoronSword',
        ];
        this.emulator = emulator;
    }
    get kokiriSword() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 7 /* KOKIRI */);
    }
    set kokiriSword(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 7 /* KOKIRI */, bool);
    }
    get masterSword() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 6 /* MASTER */);
    }
    set masterSword(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 6 /* MASTER */, bool);
    }
    get giantKnife() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 5 /* GIANT */);
    }
    set giantKnife(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 5 /* GIANT */, bool);
    }
    get biggoronSword() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 5 /* BIGGORON */);
    }
    set biggoronSword(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 5 /* BIGGORON */, bool);
        this.emulator.rdramWrite8(this.biggoron_flag_addr, bool ? 1 : 0);
    }
}
exports.SwordsEquipment = SwordsEquipment;
//# sourceMappingURL=SwordsEquipment.js.map