"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class ShieldsEquipment extends JSONTemplate_1.JSONTemplate {
    constructor(emulator) {
        super();
        this.instance = global.ModLoader.save_context;
        this.equipment_addr = this.instance + 0x009c + 1;
        this.jsonFields = ['dekuShield', 'hylianShield', 'mirrorShield'];
        this.emulator = emulator;
    }
    set dekuShield(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 3 /* DEKU */, bool);
    }
    get dekuShield() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 3 /* DEKU */);
    }
    set hylianShield(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 2 /* HYLIAN */, bool);
    }
    get hylianShield() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 2 /* HYLIAN */);
    }
    set mirrorShield(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 1 /* MIRROR */, bool);
    }
    get mirrorShield() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 1 /* MIRROR */);
    }
}
exports.ShieldsEquipment = ShieldsEquipment;
//# sourceMappingURL=ShieldsEquipment.js.map