/// <reference types="node" />
import IMemory from 'modloader64_api/IMemory';
import { ISaveContext, Magic, IQuestStatus, Age } from 'modloader64_api/OOT/OOTAPI';
import { JSONTemplate } from 'modloader64_api/JSONTemplate';
import { BootsEquipment } from './BootsEquipment';
import { TunicsEquipment } from './TunicsEquipment';
import { ShieldsEquipment } from './ShieldsEquipment';
import { SwordsEquipment } from './SwordsEquipment';
import { Inventory } from './Inventory';
import { ILogger } from 'modloader64_api/IModLoaderAPI';
export declare class SaveContext extends JSONTemplate implements ISaveContext {
    private emulator;
    private instance;
    private entrance_index_addr;
    private age_addr;
    private cutscene_number_addr;
    private world_time_addr;
    private world_night_addr;
    private zeldaz_addr;
    private death_addr;
    private player_name_addr;
    private dd_flag_addr;
    private heart_container_addr;
    private health_addr;
    private magic_meter_size_addr;
    private magic_current_addr;
    private magic_limit_addr;
    private magic_flag_1_addr;
    private magic_flag_2_addr;
    private rupees_address;
    private navi_timer_addr;
    private checksum_addr;
    private magic_beans_addr;
    private scene_data_addr;
    private event_data_addr;
    private item_flag_addr;
    private inf_table_addr;
    swords: SwordsEquipment;
    shields: ShieldsEquipment;
    tunics: TunicsEquipment;
    boots: BootsEquipment;
    inventory: Inventory;
    questStatus: IQuestStatus;
    jsonFields: string[];
    constructor(emu: IMemory, log: ILogger);
    entrance_index: number;
    cutscene_number: number;
    world_time: number;
    world_night_flag: boolean;
    readonly zeldaz_string: string;
    death_counter: number;
    readonly player_name: string;
    dd_flag: boolean;
    heart_containers: number;
    health: number;
    magic_meter_size: Magic;
    magic_current: number;
    rupee_count: number;
    navi_timer: number;
    readonly checksum: number;
    readonly age: Age;
    magic_beans_purchased: number;
    permSceneData: Buffer;
    eventFlags: Buffer;
    itemFlags: Buffer;
    infTable: Buffer;
}
