"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const FlagManager_1 = require("modloader64_api/FlagManager");
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class QuestStatus extends JSONTemplate_1.JSONTemplate {
    constructor(emu) {
        super();
        this.instance = global.ModLoader.save_context;
        this.skulltulaAddr = this.instance + 0x00d0;
        this.questFlagsAddr = this.instance + 0x00a4;
        this.jsonFields = [
            'gerudoMembershipCard',
            'stoneOfAgony',
            'displayGoldSkulltulas',
            'goldSkulltulas',
            'heartPieces',
            'zeldasLullaby',
            'eponasSong',
            'sariasSong',
            'sunsSong',
            'songOfTime',
            'songOfStorms',
            'preludeOfLight',
            'minuetOfForest',
            'boleroOfFire',
            'serenadeOfWater',
            'nocturneOfShadow',
            'requiemOfSpirit',
            'lightMedallion',
            'forestMedallion',
            'waterMedallion',
            'fireMedallion',
            'spiritMedallion',
            'shadowMedallion',
            'kokiriEmerald',
            'goronRuby',
            'zoraSapphire',
        ];
        this.gerudoMembershipCardFlag = new FlagManager_1.Flag(1, 1);
        this.stoneOfAgonyFlag = new FlagManager_1.Flag(1, 2);
        this.displayGoldSkulltulasFlag = new FlagManager_1.Flag(1, 7);
        this.zeldaasLullabyFlag = new FlagManager_1.Flag(2, 3);
        this.eponasSongFlag = new FlagManager_1.Flag(2, 2);
        this.sariasSongFlag = new FlagManager_1.Flag(2, 1);
        this.sunsSongFlag = new FlagManager_1.Flag(2, 0);
        this.songOfTimeFlag = new FlagManager_1.Flag(1, 7);
        this.songOfStormsFlag = new FlagManager_1.Flag(1, 6);
        this.preludeOfLightFlag = new FlagManager_1.Flag(2, 4);
        this.minuetOfForestFlag = new FlagManager_1.Flag(3, 1);
        this.boleroOfFireFlag = new FlagManager_1.Flag(3, 0);
        this.serenadeOfWaterFlag = new FlagManager_1.Flag(2, 7);
        this.nocturneOfShadowFlag = new FlagManager_1.Flag(2, 5);
        this.requiemOfSpiritFlag = new FlagManager_1.Flag(2, 6);
        this.lightMedallionFlag = new FlagManager_1.Flag(3, 2);
        this.forestMedallionFlag = new FlagManager_1.Flag(3, 7);
        this.fireMedallionFlag = new FlagManager_1.Flag(3, 6);
        this.waterMedallionFlag = new FlagManager_1.Flag(3, 5);
        this.shadowMedallionFlag = new FlagManager_1.Flag(3, 3);
        this.spiritMedallionFlag = new FlagManager_1.Flag(3, 4);
        this.kokiriEmeraldFlag = new FlagManager_1.Flag(1, 5);
        this.goronRubyFlag = new FlagManager_1.Flag(1, 4);
        this.zoraSapphireFlag = new FlagManager_1.Flag(1, 3);
        this.emulator = emu;
        this.questFlags = new FlagManager_1.FlagManager(emu, this.questFlagsAddr);
    }
    get gerudoMembershipCard() {
        return this.questFlags.isFlagSet(this.gerudoMembershipCardFlag);
    }
    set gerudoMembershipCard(bool) {
        this.questFlags.setFlag(this.gerudoMembershipCardFlag, bool);
    }
    get stoneOfAgony() {
        return this.questFlags.isFlagSet(this.stoneOfAgonyFlag);
    }
    set stoneOfAgony(bool) {
        this.questFlags.setFlag(this.stoneOfAgonyFlag, bool);
    }
    get displayGoldSkulltulas() {
        return this.questFlags.isFlagSet(this.displayGoldSkulltulasFlag);
    }
    set displayGoldSkulltulas(bool) {
        this.questFlags.setFlag(this.displayGoldSkulltulasFlag, bool);
    }
    get goldSkulltulas() {
        return this.emulator.rdramRead16(this.skulltulaAddr);
    }
    set goldSkulltulas(count) {
        this.emulator.rdramWrite16(this.skulltulaAddr, count);
    }
    get heartPieces() {
        return this.emulator.rdramRead8(this.questFlagsAddr + 3);
    }
    set heartPieces(count) {
        let pieces = count % 4;
        this.emulator.rdramWrite8(this.questFlagsAddr + 3, pieces);
    }
    get zeldasLullaby() {
        return this.questFlags.isFlagSet(this.zeldaasLullabyFlag);
    }
    set zeldasLullaby(bool) {
        this.questFlags.setFlag(this.zeldaasLullabyFlag, bool);
    }
    get eponasSong() {
        return this.questFlags.isFlagSet(this.eponasSongFlag);
    }
    set eponasSong(bool) {
        this.questFlags.setFlag(this.eponasSongFlag, bool);
    }
    get sariasSong() {
        return this.questFlags.isFlagSet(this.sariasSongFlag);
    }
    set sariasSong(bool) {
        this.questFlags.setFlag(this.sariasSongFlag, bool);
    }
    get sunsSong() {
        return this.questFlags.isFlagSet(this.sunsSongFlag);
    }
    set sunsSong(bool) {
        this.questFlags.setFlag(this.sunsSongFlag, bool);
    }
    get songOfTime() {
        return this.questFlags.isFlagSet(this.songOfTimeFlag);
    }
    set songOfTime(bool) {
        this.questFlags.setFlag(this.songOfTimeFlag, bool);
    }
    get songOfStorms() {
        return this.questFlags.isFlagSet(this.songOfStormsFlag);
    }
    set songOfStorms(bool) {
        this.questFlags.setFlag(this.songOfStormsFlag, bool);
    }
    get preludeOfLight() {
        return this.questFlags.isFlagSet(this.preludeOfLightFlag);
    }
    set preludeOfLight(bool) {
        this.questFlags.setFlag(this.preludeOfLightFlag, bool);
    }
    get minuetOfForest() {
        return this.questFlags.isFlagSet(this.minuetOfForestFlag);
    }
    set minuetOfForest(bool) {
        this.questFlags.setFlag(this.minuetOfForestFlag, bool);
    }
    get boleroOfFire() {
        return this.questFlags.isFlagSet(this.boleroOfFireFlag);
    }
    set boleroOfFire(bool) {
        this.questFlags.setFlag(this.boleroOfFireFlag, bool);
    }
    get serenadeOfWater() {
        return this.questFlags.isFlagSet(this.serenadeOfWaterFlag);
    }
    set serenadeOfWater(bool) {
        this.questFlags.setFlag(this.serenadeOfWaterFlag, bool);
    }
    get nocturneOfShadow() {
        return this.questFlags.isFlagSet(this.nocturneOfShadowFlag);
    }
    set nocturneOfShadow(bool) {
        this.questFlags.setFlag(this.nocturneOfShadowFlag, bool);
    }
    get requiemOfSpirit() {
        return this.questFlags.isFlagSet(this.requiemOfSpiritFlag);
    }
    set requiemOfSpirit(bool) {
        this.questFlags.setFlag(this.requiemOfSpiritFlag, bool);
    }
    get lightMedallion() {
        return this.questFlags.isFlagSet(this.lightMedallionFlag);
    }
    set lightMedallion(bool) {
        this.questFlags.setFlag(this.lightMedallionFlag, bool);
    }
    get forestMedallion() {
        return this.questFlags.isFlagSet(this.forestMedallionFlag);
    }
    set forestMedallion(bool) {
        this.questFlags.setFlag(this.forestMedallionFlag, bool);
    }
    get fireMedallion() {
        return this.questFlags.isFlagSet(this.fireMedallionFlag);
    }
    set fireMedallion(bool) {
        this.questFlags.setFlag(this.fireMedallionFlag, bool);
    }
    get waterMedallion() {
        return this.questFlags.isFlagSet(this.waterMedallionFlag);
    }
    set waterMedallion(bool) {
        this.questFlags.setFlag(this.waterMedallionFlag, bool);
    }
    get shadowMedallion() {
        return this.questFlags.isFlagSet(this.shadowMedallionFlag);
    }
    set shadowMedallion(bool) {
        this.questFlags.setFlag(this.shadowMedallionFlag, bool);
    }
    get spiritMedallion() {
        return this.questFlags.isFlagSet(this.spiritMedallionFlag);
    }
    set spiritMedallion(bool) {
        this.questFlags.setFlag(this.spiritMedallionFlag, bool);
    }
    get kokiriEmerald() {
        return this.questFlags.isFlagSet(this.kokiriEmeraldFlag);
    }
    set kokiriEmerald(bool) {
        this.questFlags.setFlag(this.kokiriEmeraldFlag, bool);
    }
    get goronRuby() {
        return this.questFlags.isFlagSet(this.goronRubyFlag);
    }
    set goronRuby(bool) {
        this.questFlags.setFlag(this.goronRubyFlag, bool);
    }
    get zoraSapphire() {
        return this.questFlags.isFlagSet(this.zoraSapphireFlag);
    }
    set zoraSapphire(bool) {
        this.questFlags.setFlag(this.zoraSapphireFlag, bool);
    }
}
exports.QuestStatus = QuestStatus;
//# sourceMappingURL=QuestStatus.js.map