"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class OotHelper extends JSONTemplate_1.JSONTemplate {
    constructor(save, global, link) {
        super();
        this.save = save;
        this.global = global;
        this.link = link;
    }
    isTitleScreen() {
        return this.save.checksum === 0;
    }
    isSceneNumberValid() {
        return this.global.scene <= 101;
    }
    isLinkEnteringLoadingZone() {
        let r = this.link.rawStateValue;
        return (r & 0x000000ff) === 1;
    }
    toJSON() {
        let jsonObj = {};
        jsonObj['isTitleScreen'] = this.isTitleScreen();
        return jsonObj;
    }
}
exports.OotHelper = OotHelper;
//# sourceMappingURL=OotHelper.js.map