"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class Link extends JSONTemplate_1.JSONTemplate {
    constructor(emu) {
        super();
        this.instance = 0x1daa30;
        this.state_addr = this.instance + 0x066c;
        this.tunic_addr = this.instance + 0x013c;
        this.shield_addr = this.instance + 0x013e;
        this.boots_addr = this.instance + 0x013f;
        this.mask_addr = this.instance + 0x014f;
        this.pos_addr = this.instance + 0x24;
        this.rot_addr = this.instance + 0xb4;
        /*This is provided by OotCore's ASM.
          Anim data is safely copied into this space at the end of each rendering cycle.
          This helps prevent jittering.*/
        this.sound_addr = 0x600000 + 0x88;
        this.anim_data_addr = 0x600000;
        this.jsonFields = [
            'state',
            'tunic',
            'shield',
            'boots',
            'mask',
            'pos',
            'rot',
            'anim_data',
            'current_sound_id',
        ];
        this.emulator = emu;
    }
    exists() {
        return this.emulator.rdramRead32(this.instance) === 0x2ff;
    }
    get rawStateValue() {
        return this.emulator.rdramRead32(this.state_addr);
    }
    get state() {
        switch (this.emulator.rdramRead32(this.state_addr)) {
            case 0:
                return 1 /* STANDING */;
            case 0x20000000:
                return 4 /* BUSY */;
            case 0x30000000:
                return 3 /* OCARINA */;
            case 0x20000001:
                return 5 /* LOADING_ZONE */;
            case 0x80000000:
                return 6 /* ENTERING_GROTTO */;
            case 0x00100000:
                return 7 /* FIRST_PERSON */;
            case 0x00040000:
                return 8 /* JUMPING */;
            case 0x08000000:
                return 2 /* SWIMMING */;
            case 0x00004000:
                return 9 /* CLIMBING_OUT_OF_WATER */;
            case 0x00002000:
                return 10 /* HANGING_FROM_LEDGE */;
            case 0x00800000:
                return 15 /* RIDING_EPONA */;
            case 0x00000080:
                return 16 /* DYING */;
            case 0x04000000:
                return 17 /* TAKING_DAMAGE */;
            case 0x00040000:
                return 18 /* FALLING */;
            case 0xa0040000:
                return 19 /* VOIDING_OUT */;
            case 0x20000c00:
                return 13 /* GETTING_ITEM */;
            case 0x20010040:
                return 20 /* TALKING */;
        }
        return 0 /* UNKNOWN */;
    }
    get tunic() {
        return this.emulator.rdramRead8(this.tunic_addr);
    }
    set tunic(tunic) {
        this.emulator.rdramWrite8(this.tunic_addr, tunic);
    }
    get shield() {
        return this.emulator.rdramRead8(this.shield_addr);
    }
    set shield(shield) {
        this.emulator.rdramWrite8(this.shield_addr, shield);
    }
    get boots() {
        return this.emulator.rdramRead8(this.boots_addr);
    }
    set boots(boots) {
        this.emulator.rdramWrite8(this.boots_addr, boots);
    }
    get mask() {
        return this.emulator.rdramRead8(this.mask_addr);
    }
    set mask(mask) {
        this.emulator.rdramWrite8(this.mask_addr, mask);
    }
    get pos() {
        return this.emulator.rdramReadBuffer(this.pos_addr, 0xc);
    }
    set pos(pos) {
        this.emulator.rdramWriteBuffer(this.pos_addr, pos);
    }
    get rot() {
        return this.emulator.rdramReadBuffer(this.rot_addr, 0x8);
    }
    set rot(rot) {
        this.emulator.rdramWriteBuffer(this.rot_addr, rot);
    }
    get anim_data() {
        return this.emulator.rdramReadBuffer(this.anim_data_addr, 0x86);
    }
    get current_sound_id() {
        return this.emulator.rdramRead16(this.sound_addr);
    }
    set current_sound_id(s) {
        this.emulator.rdramWrite16(this.sound_addr, s);
    }
    get anim_id() {
        return this.emulator.rdramRead16(this.instance + 0x1ae);
    }
    get anim_frame() {
        return this.emulator.rdramRead16(this.instance + 0x1f4);
    }
    // Give ILink a complete IMemory implementation for shortcuts.
    rdramRead8(addr) {
        return this.emulator.rdramRead8(this.instance + addr);
    }
    rdramWrite8(addr, value) {
        this.emulator.rdramWrite8(this.instance + addr, value);
    }
    rdramRead16(addr) {
        return this.emulator.rdramRead16(this.instance + addr);
    }
    rdramWrite16(addr, value) {
        this.emulator.rdramWrite16(this.instance + addr, value);
    }
    rdramWrite32(addr, value) {
        this.emulator.rdramWrite32(this.instance + addr, value);
    }
    rdramRead32(addr) {
        return this.emulator.rdramRead32(this.instance + addr);
    }
    rdramReadBuffer(addr, size) {
        return this.emulator.rdramReadBuffer(this.instance + addr, size);
    }
    rdramWriteBuffer(addr, buf) {
        this.emulator.rdramWriteBuffer(this.instance + addr, buf);
    }
    dereferencePointer(addr) {
        return this.emulator.dereferencePointer(this.instance + addr);
    }
    rdramReadS8(addr) {
        return this.emulator.rdramReadS8(this.instance + addr);
    }
    rdramReadS16(addr) {
        return this.emulator.rdramReadS16(this.instance + addr);
    }
    rdramReadS32(addr) {
        return this.emulator.rdramReadS32(this.instance + addr);
    }
    rdramReadBitsBuffer(addr, bytes) {
        return this.emulator.rdramReadBitsBuffer(this.instance + addr, bytes);
    }
    rdramReadBits8(addr) {
        return this.emulator.rdramReadBits8(this.instance + addr);
    }
    rdramReadBit8(addr, bitoffset) {
        return this.emulator.rdramReadBit8(this.instance + addr, bitoffset);
    }
    rdramWriteBitsBuffer(addr, buf) {
        this.emulator.rdramWriteBitsBuffer(this.instance + addr, buf);
    }
    rdramWriteBits8(addr, buf) {
        this.emulator.rdramWriteBits8(this.instance + addr, buf);
    }
    rdramWriteBit8(addr, bitoffset, bit) {
        this.emulator.rdramWriteBit8(this.instance + addr, bitoffset, bit);
    }
    rdramReadPtr8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead8(pointer + offset);
    }
    rdramWritePtr8(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite8(pointer + offset, value);
    }
    rdramReadPtr16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead16(pointer + offset);
    }
    rdramWritePtr16(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite16(pointer + offset, value);
    }
    rdramWritePtr32(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite32(pointer + offset, value);
    }
    rdramReadPtr32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead32(pointer + offset);
    }
    rdramReadPtrBuffer(addr, offset, size) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBuffer(pointer + offset, size);
    }
    rdramWritePtrBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBuffer(pointer + offset, buf);
    }
    rdramReadPtrS8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS8(pointer + offset);
    }
    rdramReadPtrS16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS16(pointer + offset);
    }
    rdramReadPtrS32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS32(pointer + offset);
    }
    rdramReadPtrBitsBuffer(addr, offset, bytes) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBitsBuffer(pointer + offset, bytes);
    }
    rdramReadPtrBits8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBits8(pointer + offset);
    }
    rdramReadPtrBit8(addr, offset, bitoffset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBit8(pointer + offset, bitoffset);
    }
    rdramWritePtrBitsBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBitsBuffer(pointer + offset, buf);
    }
    rdramWritePtrBits8(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBits8(pointer + offset, buf);
    }
    rdramWritePtrBit8(addr, offset, bitoffset, bit) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBit8(pointer + offset, bitoffset, bit);
    }
}
exports.Link = Link;
//# sourceMappingURL=Link.js.map