/// <reference types="node" />
import IMemory from 'modloader64_api/IMemory';
import { LinkState, Tunic, Shield, Boots, Mask, ILink } from 'modloader64_api/OOT/OOTAPI';
import { JSONTemplate } from 'modloader64_api/JSONTemplate';
export declare class Link extends JSONTemplate implements ILink {
    private emulator;
    private instance;
    private state_addr;
    private tunic_addr;
    private shield_addr;
    private boots_addr;
    private mask_addr;
    private pos_addr;
    private rot_addr;
    private sound_addr;
    private anim_data_addr;
    jsonFields: string[];
    constructor(emu: IMemory);
    exists(): boolean;
    readonly rawStateValue: number;
    readonly state: LinkState;
    tunic: Tunic;
    shield: Shield;
    boots: Boots;
    mask: Mask;
    pos: Buffer;
    rot: Buffer;
    readonly anim_data: Buffer;
    current_sound_id: number;
    readonly anim_id: number;
    readonly anim_frame: number;
    rdramRead8(addr: number): number;
    rdramWrite8(addr: number, value: number): void;
    rdramRead16(addr: number): number;
    rdramWrite16(addr: number, value: number): void;
    rdramWrite32(addr: number, value: number): void;
    rdramRead32(addr: number): number;
    rdramReadBuffer(addr: number, size: number): Buffer;
    rdramWriteBuffer(addr: number, buf: Buffer): void;
    dereferencePointer(addr: number): number;
    rdramReadS8(addr: number): number;
    rdramReadS16(addr: number): number;
    rdramReadS32(addr: number): number;
    rdramReadBitsBuffer(addr: number, bytes: number): Buffer;
    rdramReadBits8(addr: number): Buffer;
    rdramReadBit8(addr: number, bitoffset: number): boolean;
    rdramWriteBitsBuffer(addr: number, buf: Buffer): void;
    rdramWriteBits8(addr: number, buf: Buffer): void;
    rdramWriteBit8(addr: number, bitoffset: number, bit: boolean): void;
    rdramReadPtr8(addr: number, offset: number): number;
    rdramWritePtr8(addr: number, offset: number, value: number): void;
    rdramReadPtr16(addr: number, offset: number): number;
    rdramWritePtr16(addr: number, offset: number, value: number): void;
    rdramWritePtr32(addr: number, offset: number, value: number): void;
    rdramReadPtr32(addr: number, offset: number): number;
    rdramReadPtrBuffer(addr: number, offset: number, size: number): Buffer;
    rdramWritePtrBuffer(addr: number, offset: number, buf: Buffer): void;
    rdramReadPtrS8(addr: number, offset: number): number;
    rdramReadPtrS16(addr: number, offset: number): number;
    rdramReadPtrS32(addr: number, offset: number): number;
    rdramReadPtrBitsBuffer(addr: number, offset: number, bytes: number): Buffer;
    rdramReadPtrBits8(addr: number, offset: number): Buffer;
    rdramReadPtrBit8(addr: number, offset: number, bitoffset: number): boolean;
    rdramWritePtrBitsBuffer(addr: number, offset: number, buf: Buffer): void;
    rdramWritePtrBits8(addr: number, offset: number, buf: Buffer): void;
    rdramWritePtrBit8(addr: number, offset: number, bitoffset: number, bit: boolean): void;
}
