"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const OOTAPI_1 = __importDefault(require("modloader64_api/OOT/OOTAPI"));
class KeyManager {
    constructor(emulator) {
        this.KEY_ARRAY_ADDR = global.ModLoader['save_context'] + 0xbc;
        this.KEY_ARRAY_SIZE = 0x14;
        this.emulator = emulator;
    }
    getKeyCountForIndex(index) {
        if (index > this.KEY_ARRAY_ADDR) {
            return OOTAPI_1.default.NO_KEYS;
        }
        return this.emulator.rdramRead8(this.KEY_ARRAY_ADDR + index);
    }
    setKeyCountByIndex(index, count) {
        if (index > this.KEY_ARRAY_ADDR) {
            return;
        }
        this.emulator.rdramWrite8(this.KEY_ARRAY_ADDR + index, count);
    }
    getRawKeyBuffer() {
        return this.emulator.rdramReadBuffer(this.KEY_ARRAY_ADDR, this.KEY_ARRAY_SIZE);
    }
}
exports.KeyManager = KeyManager;
//# sourceMappingURL=KeyManager.js.map