"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class Inventory extends JSONTemplate_1.JSONTemplate {
    constructor(emu, log) {
        super();
        this.instance = global.ModLoader.save_context;
        this.inventory_addr = this.instance + 0x0074;
        this.inventory_ammo_addr = this.instance + 0x008c;
        this.inventory_upgrades_addr = this.instance + 0x00a0;
        this.jsonFields = [
            'dekuSticks',
            'dekuNuts',
            'bombs',
            'bombchus',
            'magicBeans',
            'fairySlingshot',
            'fairyBow',
            'fireArrows',
            'iceArrows',
            'lightArrows',
            'dinsFire',
            'faroresWind',
            'nayrusLove',
            'ocarina',
            'hookshot',
            'boomerang',
            'lensOfTruth',
            'megatonHammer',
            'bottle_1',
            'bottle_2',
            'bottle_3',
            'bottle_4',
            'childTradeItem',
            'adultTradeItem',
            'wallet',
            'quiver',
            'bulletBag',
            'bombBag',
            'dekuNutsCapacity',
            'dekuSticksCapacity',
            'swimming',
            'strength',
        ];
        this.emulator = emu;
        this.log = log;
    }
    set strength(bb) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x2);
        let slice = buf.slice(4, 7);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* GORON_BRACELET */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* SILVER_GAUNTLETS */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* GOLDEN_GAUNTLETS */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x1, buf);
    }
    get strength() {
        let buf = this.emulator.rdramReadBitsBuffer(this.inventory_upgrades_addr + 0x2, 0x2);
        let str = buf.toString('hex');
        str = str.substr(7 * 2, 3 * 2);
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* GORON_BRACELET */;
            case '000100':
                return 2 /* SILVER_GAUNTLETS */;
            case '000101':
                return 3 /* GOLDEN_GAUNTLETS */;
            case '010000':
                return 4 /* BLACK_GAUNTLETS */;
            case '010001':
                return 5 /* GREEN_GAUNTLETS */;
            case '010100':
                return 6 /* BLUE_GAUNTLETS */;
        }
        return 0 /* NONE */;
    }
    set swimming(bb) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x2);
        let slice = buf.slice(4, 7);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* SILVER */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* GOLDEN */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 2 /* GOLDEN */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x2, buf);
    }
    get swimming() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x2);
        let str = buf.slice(4, 7).toString('hex');
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* SILVER */;
            case '000100':
                return 2 /* GOLDEN */;
            case '000101':
                return 2 /* GOLDEN */;
        }
        return 0 /* NONE */;
    }
    set dekuSticksCapacity(bb) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x1);
        let slice = buf.slice(4, 7);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* BASE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* UPGRADED */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* MAX */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x1, buf);
    }
    get dekuSticksCapacity() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x1);
        let str = buf.slice(4, 7).toString('hex');
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* BASE */;
            case '000100':
                return 2 /* UPGRADED */;
            case '000101':
                return 3 /* MAX */;
        }
        return 0 /* NONE */;
    }
    set dekuNutsCapacity(bb) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x1);
        let slice = buf.slice(1, 4);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* BASE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* UPGRADED */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* MAX */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x1, buf);
    }
    get dekuNutsCapacity() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x1);
        let str = buf.slice(1, 4).toString('hex');
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* BASE */;
            case '000100':
                return 2 /* UPGRADED */;
            case '000101':
                return 3 /* MAX */;
        }
        return 0 /* NONE */;
    }
    set bombBag(bb) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x3);
        let slice = buf.slice(2, 5);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* BASE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* UPGRADED */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* MAX */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x3, buf);
    }
    get bombBag() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x3);
        let str = buf.slice(2, 5).toString('hex');
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* BASE */;
            case '000100':
                return 2 /* UPGRADED */;
            case '000101':
                return 3 /* MAX */;
        }
        return 0 /* NONE */;
    }
    get bulletBag() {
        let buf = this.emulator.rdramReadBitsBuffer(this.inventory_upgrades_addr + 0x1, 0x2);
        let str = buf.toString('hex');
        str = str.substr(7 * 2, 3 * 2);
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* BASE */;
            case '000100':
                return 2 /* UPGRADED */;
            case '000101':
                return 3 /* MAX */;
        }
        return 0 /* NONE */;
    }
    set bulletBag(bb) {
        let buf = this.emulator.rdramReadBitsBuffer(this.inventory_upgrades_addr + 0x1, 0x2);
        let slice = buf.slice(7, 11);
        switch (bb) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* BASE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* UPGRADED */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* MAX */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBitsBuffer(this.inventory_upgrades_addr + 0x1, buf);
    }
    get quiver() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x3);
        let str = buf.slice(5, 8).toString('hex');
        switch (str) {
            case '000000':
                return 0 /* NONE */;
            case '000001':
                return 1 /* BASE */;
            case '000100':
                return 2 /* UPGRADED */;
            case '000101':
                return 3 /* MAX */;
        }
        return 0 /* NONE */;
    }
    set quiver(q) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x3);
        let slice = buf.slice(5, 8);
        switch (q) {
            case 0 /* NONE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x00;
                break;
            case 1 /* BASE */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                slice[0x2] = 0x01;
                break;
            case 2 /* UPGRADED */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x00;
                break;
            case 3 /* MAX */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                slice[0x2] = 0x01;
                break;
        }
        this.emulator.rdramWriteBits8(this.inventory_upgrades_addr + 0x3, buf);
    }
    get wallet() {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x2);
        let str = buf.slice(2, 4).toString('hex');
        switch (str) {
            case '0000':
                return 0 /* CHILD */;
            case '0001':
                return 1 /* ADULT */;
            case '0100':
                return 2 /* GIANT */;
            case '0101':
                return 3 /* TYCOON */;
        }
        return 0 /* CHILD */;
    }
    set wallet(w) {
        let buf = this.emulator.rdramReadBits8(this.inventory_upgrades_addr + 0x2);
        let slice = buf.slice(2, 4);
        switch (w) {
            case 0 /* CHILD */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x00;
                break;
            case 1 /* ADULT */:
                slice[0x0] = 0x00;
                slice[0x1] = 0x01;
                break;
            case 2 /* GIANT */:
                slice[0x0] = 0x10;
                slice[0x1] = 0x00;
                break;
            case 3 /* TYCOON */:
                slice[0x0] = 0x01;
                slice[0x1] = 0x01;
        }
        this.emulator.rdramWriteBits8(this.inventory_upgrades_addr + 0x2, buf);
    }
    get dekuSticks() {
        return this.hasItem(0 /* DEKU_STICK */);
    }
    set dekuSticks(bool) {
        if (bool) {
            this.giveItem(0 /* DEKU_STICK */, 0 /* DEKU_STICKS */);
        }
        else {
            this.removeItem(0 /* DEKU_STICK */);
            this.dekuSticksCapacity = 0 /* NONE */;
        }
    }
    get dekuSticksCount() {
        return this.getAmmoForItem(0 /* DEKU_STICK */);
    }
    set dekuSticksCount(count) {
        let slot = this.getSlotForItem(0 /* DEKU_STICK */);
        this.setAmmoInSlot(slot, count);
    }
    get dekuNuts() {
        return this.hasItem(1 /* DEKU_NUT */);
    }
    set dekuNuts(bool) {
        if (bool) {
            this.giveItem(0 /* DEKU_STICK */, 1 /* DEKU_NUTS */);
        }
        else {
            this.removeItem(1 /* DEKU_NUT */);
            this.dekuSticksCapacity = 0 /* NONE */;
        }
    }
    get dekuNutsCount() {
        return this.getAmmoForItem(1 /* DEKU_NUT */);
    }
    set dekuNutsCount(count) {
        let slot = this.getSlotForItem(1 /* DEKU_NUT */);
        this.setAmmoInSlot(slot, count);
    }
    get bombs() {
        return this.hasItem(2 /* BOMB */);
    }
    set bombs(bool) {
        if (bool) {
            this.giveItem(2 /* BOMB */, 2 /* BOMBS */);
        }
        else {
            this.removeItem(2 /* BOMB */);
            this.bombBag = 0 /* NONE */;
        }
    }
    get bombsCount() {
        return this.getAmmoForItem(2 /* BOMB */);
    }
    set bombsCount(count) {
        let slot = this.getSlotForItem(2 /* BOMB */);
        this.setAmmoInSlot(slot, count);
    }
    get bombchus() {
        return this.hasItem(9 /* BOMBCHU */);
    }
    set bombchus(bool) {
        if (bool) {
            this.giveItem(9 /* BOMBCHU */, 8 /* BOMBCHUS */);
        }
        else {
            this.removeItem(9 /* BOMBCHU */);
        }
    }
    get bombchuCount() {
        return this.getAmmoForItem(9 /* BOMBCHU */);
    }
    set bombchuCount(count) {
        let slot = this.getSlotForItem(9 /* BOMBCHU */);
        this.setAmmoInSlot(slot, count);
    }
    get magicBeans() {
        return this.hasItem(16 /* MAGIC_BEAN */);
    }
    set magicBeans(bool) {
        if (bool) {
            this.giveItem(16 /* MAGIC_BEAN */, 14 /* MAGIC_BEANS */);
        }
        else {
            this.removeItem(16 /* MAGIC_BEAN */);
        }
    }
    get magicBeansCount() {
        return this.getAmmoForItem(16 /* MAGIC_BEAN */);
    }
    set magicBeansCount(count) {
        let slot = this.getSlotForItem(16 /* MAGIC_BEAN */);
        this.setAmmoInSlot(slot, count);
    }
    get fairySlingshot() {
        return this.hasItem(6 /* FAIRY_SLINGSHOT */);
    }
    set fairySlingshot(bool) {
        if (bool) {
            this.giveItem(6 /* FAIRY_SLINGSHOT */, 6 /* FAIRY_SLINGSHOT */);
        }
        else {
            this.removeItem(6 /* FAIRY_SLINGSHOT */);
            this.bulletBag = 0 /* NONE */;
        }
    }
    get dekuSeeds() {
        return this.getAmmoForItem(6 /* FAIRY_SLINGSHOT */);
    }
    set dekuSeeds(count) {
        let slot = this.getSlotForItem(6 /* FAIRY_SLINGSHOT */);
        this.setAmmoInSlot(slot, count);
    }
    get fairyBow() {
        return this.hasItem(3 /* FAIRY_BOW */);
    }
    set fairyBow(bool) {
        if (bool) {
            this.giveItem(3 /* FAIRY_BOW */, 3 /* FAIRY_BOW */);
        }
        else {
            this.removeItem(3 /* FAIRY_BOW */);
            this.quiver = 0 /* NONE */;
        }
    }
    get arrows() {
        return this.getAmmoForItem(3 /* FAIRY_BOW */);
    }
    set arrows(count) {
        let slot = this.getSlotForItem(3 /* FAIRY_BOW */);
        this.setAmmoInSlot(slot, count);
    }
    get fireArrows() {
        return this.hasItem(4 /* FIRE_ARROW */);
    }
    set fireArrows(bool) {
        if (bool) {
            this.giveItem(4 /* FIRE_ARROW */, 4 /* FIRE_ARROWS */);
        }
        else {
            this.removeItem(4 /* FIRE_ARROW */);
        }
    }
    get iceArrows() {
        return this.hasItem(12 /* ICE_ARROW */);
    }
    set iceArrows(bool) {
        if (bool) {
            this.giveItem(12 /* ICE_ARROW */, 10 /* ICE_ARROWS */);
        }
        else {
            this.removeItem(12 /* ICE_ARROW */);
        }
    }
    get lightArrows() {
        return this.hasItem(18 /* LIGHT_ARROW */);
    }
    set lightArrows(bool) {
        if (bool) {
            this.giveItem(18 /* LIGHT_ARROW */, 16 /* LIGHT_ARROWS */);
        }
        else {
            this.removeItem(18 /* LIGHT_ARROW */);
        }
    }
    get dinsFire() {
        return this.hasItem(5 /* DINS_FIRE */);
    }
    set dinsFire(bool) {
        if (bool) {
            this.giveItem(5 /* DINS_FIRE */, 5 /* DINS_FIRE */);
        }
        else {
            this.removeItem(5 /* DINS_FIRE */);
        }
    }
    get faroresWind() {
        return this.hasItem(13 /* FARORES_WIND */);
    }
    set faroresWind(bool) {
        if (bool) {
            this.giveItem(13 /* FARORES_WIND */, 11 /* FARORES_WIND */);
        }
        else {
            this.removeItem(13 /* FARORES_WIND */);
        }
    }
    get nayrusLove() {
        return this.hasItem(19 /* NAYRUS_LOVE */);
    }
    set nayrusLove(bool) {
        if (bool) {
            this.giveItem(19 /* NAYRUS_LOVE */, 17 /* NAYRUS_LOVE */);
        }
        else {
            this.removeItem(19 /* NAYRUS_LOVE */);
        }
    }
    get ocarina() {
        if (this.hasItem(8 /* OCARINA_OF_TIME */)) {
            return 2 /* OCARINA_OF_TIME */;
        }
        if (this.hasItem(7 /* FAIRY_OCARINA */)) {
            return 1 /* FAIRY_OCARINA */;
        }
        return 0 /* NONE */;
    }
    set ocarina(item) {
        if (item == this.ocarina) {
            return;
        }
        if (item == 0 /* NONE */) {
            this.removeItem(8 /* OCARINA_OF_TIME */);
            this.removeItem(7 /* FAIRY_OCARINA */);
        }
        if (item == 2 /* OCARINA_OF_TIME */) {
            let slot = this.getSlotForItem(7 /* FAIRY_OCARINA */);
            if (slot > -1) {
                this.setItemInSlot(8 /* OCARINA_OF_TIME */, slot);
            }
            else {
                this.giveItem(8 /* OCARINA_OF_TIME */, 7 /* OCARINA */);
            }
        }
        if (item == 1 /* FAIRY_OCARINA */) {
            let slot = this.getSlotForItem(8 /* OCARINA_OF_TIME */);
            if (slot > -1) {
                this.setItemInSlot(7 /* FAIRY_OCARINA */, slot);
            }
            else {
                this.giveItem(7 /* FAIRY_OCARINA */, 7 /* OCARINA */);
            }
        }
    }
    get hookshot() {
        if (this.hasItem(11 /* LONGSHOT */)) {
            return 2 /* LONGSHOT */;
        }
        if (this.hasItem(10 /* HOOKSHOT */)) {
            return 2 /* LONGSHOT */;
        }
        return 0 /* NONE */;
    }
    set hookshot(item) {
        if (item == this.hookshot) {
            return;
        }
        if (item == 0 /* NONE */) {
            this.removeItem(10 /* HOOKSHOT */);
            this.removeItem(11 /* LONGSHOT */);
        }
        if (item == 2 /* LONGSHOT */) {
            let slot = this.getSlotForItem(10 /* HOOKSHOT */);
            if (slot > -1) {
                this.setItemInSlot(11 /* LONGSHOT */, slot);
            }
            else {
                this.giveItem(11 /* LONGSHOT */, 9 /* HOOKSHOT */);
            }
        }
        if (item == 1 /* HOOKSHOT */) {
            let slot = this.getSlotForItem(11 /* LONGSHOT */);
            if (slot > -1) {
                this.setItemInSlot(10 /* HOOKSHOT */, slot);
            }
            else {
                this.giveItem(10 /* HOOKSHOT */, 9 /* HOOKSHOT */);
            }
        }
    }
    get boomerang() {
        return this.hasItem(14 /* BOOMERANG */);
    }
    set boomerang(bool) {
        if (bool) {
            this.giveItem(14 /* BOOMERANG */, 12 /* BOOMERANG */);
        }
        else {
            this.removeItem(14 /* BOOMERANG */);
        }
    }
    get lensOfTruth() {
        return this.hasItem(15 /* LENS_OF_TRUTH */);
    }
    set lensOfTruth(bool) {
        if (bool) {
            this.giveItem(15 /* LENS_OF_TRUTH */, 13 /* LENS_OF_TRUTH */);
        }
        else {
            this.removeItem(15 /* LENS_OF_TRUTH */);
        }
    }
    get megatonHammer() {
        return this.hasItem(17 /* MEGATON_HAMMER */);
    }
    set megatonHammer(bool) {
        if (bool) {
            this.giveItem(17 /* MEGATON_HAMMER */, 15 /* MEGATON_HAMMER */);
        }
        else {
            this.removeItem(17 /* MEGATON_HAMMER */);
        }
    }
    get bottle_1() {
        return this.getItemInSlot(18 /* BOTTLE1 */);
    }
    set bottle_1(content) {
        this.setItemInSlot(content, 18 /* BOTTLE1 */);
    }
    get bottle_2() {
        return this.getItemInSlot(19 /* BOTTLE2 */);
    }
    set bottle_2(content) {
        this.setItemInSlot(content, 19 /* BOTTLE2 */);
    }
    get bottle_3() {
        return this.getItemInSlot(20 /* BOTTLE3 */);
    }
    set bottle_3(content) {
        this.setItemInSlot(content, 20 /* BOTTLE3 */);
    }
    get bottle_4() {
        return this.getItemInSlot(21 /* BOTTLE4 */);
    }
    set bottle_4(content) {
        this.setItemInSlot(content, 21 /* BOTTLE4 */);
    }
    hasBottle() {
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            let item = this.getItemInSlot(i);
            if (item >= 20 /* EMPTY_BOTTLE */ &&
                item <= 32 /* BOTTLED_POE */) {
                return true;
            }
        }
        return false;
    }
    getBottleCount() {
        let bottles = 0;
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            let item = this.getItemInSlot(i);
            if (item >= 20 /* EMPTY_BOTTLE */ &&
                item <= 32 /* BOTTLED_POE */) {
                bottles++;
            }
        }
        return bottles;
    }
    getBottledItems() {
        let bottles = new Array();
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            let item = this.getItemInSlot(i);
            if (item >= 20 /* EMPTY_BOTTLE */ &&
                item <= 32 /* BOTTLED_POE */) {
                bottles.push(item);
            }
        }
        return bottles;
    }
    get childTradeItem() {
        for (let i = 43 /* MASK_OF_TRUTH */; i >= 35 /* ZELDAS_LETTER */; i--) {
            if (this.hasItem(i)) {
                return i;
            }
        }
        if (this.hasItem(44 /* SOLD_OUT */)) {
            // More complex logic is required here to grab the last mask the child had
        }
        return 255 /* NONE */;
    }
    set childTradeItem(item) {
        // More complex logic is required here because of flags
    }
    get adultTradeItem() {
        for (let i = 55 /* CLAIM_CHECK */; i >= 45 /* POCKET_EGG */; i--) {
            if (i == 44 /* SOLD_OUT */) {
                continue;
            }
            if (this.hasItem(i)) {
                return i;
            }
        }
        return 255 /* NONE */;
    }
    set adultTradeItem(item) {
        // More complex logic is required here because of flags
    }
    isChildTradeFinished() {
        // This is going to require more complex flag checks
        return true;
    }
    isAdultTradeFinished() {
        // This should be done with flags also
        return true;
    }
    getItemInSlot(slotId) {
        if (slotId < 0 || slotId > 23) {
            return 255 /* NONE */;
        }
        let itemId = this.emulator.rdramRead8(this.inventory_addr + slotId);
        return itemId;
    }
    getSlotForItem(item) {
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            if (this.getItemInSlot(i) == item) {
                return i;
            }
        }
        return -1;
    }
    getSlotsForItem(item) {
        let slots = new Array();
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            if (this.getItemInSlot(i) == item) {
                slots.push(i);
            }
        }
        return slots;
    }
    hasItem(item) {
        return this.getSlotForItem(item) != -1;
    }
    getAmmoForItem(item) {
        if (!this.hasAmmo(item)) {
            return 0;
        }
        let ammo = 0;
        let slots = this.getSlotsForItem(item);
        for (let i = 0; i < slots.length; i++) {
            ammo += this.getAmmoForSlot(slots[i]);
        }
        return ammo;
    }
    hasAmmo(item) {
        switch (item) {
            case 0 /* DEKU_STICK */:
            case 1 /* DEKU_NUT */:
            case 6 /* FAIRY_SLINGSHOT */:
            case 3 /* FAIRY_BOW */:
            case 2 /* BOMB */:
            case 9 /* BOMBCHU */:
            case 16 /* MAGIC_BEAN */:
                return true;
        }
        return false;
    }
    getAmmoForSlot(slotId) {
        if (slotId < 0 || slotId > 0xf) {
            return 0;
        }
        return this.emulator.rdramRead8(this.inventory_ammo_addr + slotId);
    }
    setAmmoInSlot(slot, amount) {
        if (slot < 0 || slot >= 0xf) {
            return;
        }
        this.emulator.rdramWrite8(this.inventory_ammo_addr + slot, amount);
    }
    setItemInSlot(item, slot) {
        if (slot < 0 || slot > 23 /* CHILD_TRADE_ITEM */) {
            return;
        }
        this.emulator.rdramWrite8(this.inventory_addr + slot, item.valueOf());
    }
    giveItem(item, desiredSlot) {
        if (this.getItemInSlot(desiredSlot) == 255 /* NONE */ ||
            this.getItemInSlot(desiredSlot) == item) {
            this.setItemInSlot(item, desiredSlot);
        }
        else {
            this.setItemInSlot(item, this.getEmptySlots()[0]);
        }
    }
    removeItem(item) {
        let slots = this.getSlotsForItem(item);
        for (let i = 0; i < slots.length; i++) {
            this.setItemInSlot(255 /* NONE */, i);
        }
    }
    getEmptySlots() {
        let slots = new Array();
        for (let i = 0; i <= 23 /* CHILD_TRADE_ITEM */; i++) {
            if (this.getItemInSlot(i) == 255 /* NONE */) {
                slots.push(i);
            }
        }
        return slots;
    }
}
exports.Inventory = Inventory;
//# sourceMappingURL=Inventory.js.map