import IMemory from 'modloader64_api/IMemory';
import { InventoryItem, Ocarina, Hookshot, AmmoUpgrade, IInventory, Wallet, Strength, ZoraScale, InventorySlots } from 'modloader64_api/OOT/OOTAPI';
import { JSONTemplate } from 'modloader64_api/JSONTemplate';
import { ILogger } from 'modloader64_api/IModLoaderAPI';
export declare class Inventory extends JSONTemplate implements IInventory {
    private emulator;
    private instance;
    private inventory_addr;
    private inventory_ammo_addr;
    private inventory_upgrades_addr;
    private log;
    jsonFields: string[];
    constructor(emu: IMemory, log: ILogger);
    strength: Strength;
    swimming: ZoraScale;
    dekuSticksCapacity: AmmoUpgrade;
    dekuNutsCapacity: AmmoUpgrade;
    bombBag: AmmoUpgrade;
    bulletBag: AmmoUpgrade;
    quiver: AmmoUpgrade;
    wallet: Wallet;
    dekuSticks: boolean;
    dekuSticksCount: number;
    dekuNuts: boolean;
    dekuNutsCount: number;
    bombs: boolean;
    bombsCount: number;
    bombchus: boolean;
    bombchuCount: number;
    magicBeans: boolean;
    magicBeansCount: number;
    fairySlingshot: boolean;
    dekuSeeds: number;
    fairyBow: boolean;
    arrows: number;
    fireArrows: boolean;
    iceArrows: boolean;
    lightArrows: boolean;
    dinsFire: boolean;
    faroresWind: boolean;
    nayrusLove: boolean;
    ocarina: Ocarina;
    hookshot: Hookshot;
    boomerang: boolean;
    lensOfTruth: boolean;
    megatonHammer: boolean;
    bottle_1: InventoryItem;
    bottle_2: InventoryItem;
    bottle_3: InventoryItem;
    bottle_4: InventoryItem;
    hasBottle(): boolean;
    getBottleCount(): number;
    getBottledItems(): InventoryItem[];
    childTradeItem: InventoryItem;
    adultTradeItem: InventoryItem;
    isChildTradeFinished(): boolean;
    isAdultTradeFinished(): boolean;
    getItemInSlot(slotId: number): InventoryItem;
    getSlotForItem(item: InventoryItem): number;
    getSlotsForItem(item: InventoryItem): number[];
    hasItem(item: InventoryItem): boolean;
    getAmmoForItem(item: InventoryItem): number;
    hasAmmo(item: InventoryItem): boolean;
    getAmmoForSlot(slotId: number): number;
    setAmmoInSlot(slot: number, amount: number): void;
    setItemInSlot(item: InventoryItem, slot: number): void;
    giveItem(item: InventoryItem, desiredSlot: InventorySlots): void;
    removeItem(item: InventoryItem): void;
    getEmptySlots(): number[];
}
