"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class GlobalContext extends JSONTemplate_1.JSONTemplate {
    constructor(emulator) {
        super();
        this.current_scene_addr = 0x0000a4;
        this.switch_flags_addr = 0x001d28;
        this.temp_switch_flags_addr = 0x001d2c;
        this.chest_flags_addr = 0x001d38;
        this.room_clear_flags_addr = 0x001d3c;
        this.current_room_addr = 0x011cbc;
        this.frame_count_addr = 0x011de4;
        this.scene_frame_count_addr = 0x9c;
        this.collectable_flag_addr = 0x01d44;
        this.continue_state_addr = 0x98;
        this.jsonFields = ['scene', 'room', 'framecount'];
        this.emulator = emulator;
    }
    get scene() {
        return this.emulator.rdramReadPtr16(global.ModLoader.global_context_pointer, this.current_scene_addr);
    }
    get room() {
        return this.emulator.rdramReadPtr8(global.ModLoader.global_context_pointer, this.current_room_addr);
    }
    get framecount() {
        return this.emulator.rdramReadPtr32(global.ModLoader.global_context_pointer, this.frame_count_addr);
    }
    get scene_framecount() {
        return this.emulator.rdramReadPtr32(global.ModLoader.global_context_pointer, this.scene_frame_count_addr);
    }
    get liveSceneData_chests() {
        return this.emulator.rdramReadPtrBuffer(global.ModLoader.global_context_pointer, this.chest_flags_addr, 0x4);
    }
    set liveSceneData_chests(buf) {
        this.emulator.rdramWritePtrBuffer(global.ModLoader.global_context_pointer, this.chest_flags_addr, buf);
    }
    get liveSceneData_clear() {
        return this.emulator.rdramReadBuffer(this.room_clear_flags_addr, 0x4);
    }
    set liveSceneData_clear(buf) {
        this.emulator.rdramWritePtrBuffer(global.ModLoader.global_context_pointer, this.room_clear_flags_addr, buf);
    }
    get liveSceneData_switch() {
        return this.emulator.rdramReadPtrBuffer(global.ModLoader.global_context_pointer, this.switch_flags_addr, 0x4);
    }
    set liveSceneData_switch(buf) {
        this.emulator.rdramWritePtrBuffer(global.ModLoader.global_context_pointer, this.switch_flags_addr, buf);
    }
    get liveSceneData_temp() {
        return this.emulator.rdramReadPtrBuffer(global.ModLoader.global_context_pointer, this.temp_switch_flags_addr, 0x4);
    }
    set liveSceneData_temp(buf) {
        this.emulator.rdramWritePtrBuffer(global.ModLoader.global_context_pointer, this.temp_switch_flags_addr, buf);
    }
    get liveSceneData_collectable() {
        return this.emulator.rdramReadPtrBuffer(global.ModLoader.global_context_pointer, this.collectable_flag_addr, 0x8);
    }
    set liveSceneData_collectable(buf) {
        this.emulator.rdramWritePtrBuffer(global.ModLoader.global_context_pointer, this.collectable_flag_addr, buf);
    }
    get continue_state() {
        return (this.emulator.rdramReadPtr32(global.ModLoader.global_context_pointer, this.continue_state_addr) === 1);
    }
}
exports.GlobalContext = GlobalContext;
//# sourceMappingURL=GlobalContext.js.map