"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
class BootsEquipment extends JSONTemplate_1.JSONTemplate {
    constructor(emulator) {
        super();
        this.instance = global.ModLoader.save_context;
        this.equipment_addr = this.instance + 0x009c;
        this.jsonFields = ['kokiriBoots', 'ironBoots', 'hoverBoots'];
        this.emulator = emulator;
    }
    get kokiriBoots() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 3 /* KOKIRI */);
    }
    set kokiriBoots(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 3 /* KOKIRI */, bool);
    }
    get ironBoots() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 2 /* IRON */);
    }
    set ironBoots(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 2 /* IRON */, bool);
    }
    get hoverBoots() {
        return this.emulator.rdramReadBit8(this.equipment_addr, 1 /* HOVER */);
    }
    set hoverBoots(bool) {
        this.emulator.rdramWriteBit8(this.equipment_addr, 1 /* HOVER */, bool);
    }
}
exports.BootsEquipment = BootsEquipment;
//# sourceMappingURL=BootsEquipment.js.map