"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const JSONTemplate_1 = require("modloader64_api/JSONTemplate");
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const ROTATION_OFFSET = 0xb4;
const ROTATION_SIZE = 0x6;
const POSITION_OFFSET = 0x24;
const POSITION_SIZE = 0xc;
class Position extends JSONTemplate_1.JSONTemplate {
    constructor(parent) {
        super();
        this.jsonFields = ['x', 'y', 'z'];
        this.parent = parent;
    }
    get x() {
        return this.parent.rdramReadS32(POSITION_OFFSET + 0);
    }
    set x(x) {
        this.parent.rdramWrite32(POSITION_OFFSET + 0, x);
    }
    get y() {
        return this.parent.rdramReadS32(POSITION_OFFSET + 4);
    }
    set y(y) {
        this.parent.rdramWrite32(POSITION_OFFSET + 4, y);
    }
    get z() {
        return this.parent.rdramReadS32(POSITION_OFFSET + 8);
    }
    set z(z) {
        this.parent.rdramWrite32(POSITION_OFFSET + 8, z);
    }
    getRawPos() {
        return this.parent.rdramReadBuffer(POSITION_OFFSET, POSITION_SIZE);
    }
}
exports.Position = Position;
class Rotation extends JSONTemplate_1.JSONTemplate {
    constructor(parent) {
        super();
        this.jsonFields = ['x', 'y', 'z'];
        this.parent = parent;
    }
    get x() {
        return this.parent.rdramReadS16(ROTATION_OFFSET + 0);
    }
    set x(x) {
        this.parent.rdramWrite16(ROTATION_OFFSET + 0, x);
    }
    get y() {
        return this.parent.rdramReadS16(ROTATION_OFFSET + 2);
    }
    set y(y) {
        this.parent.rdramWrite16(ROTATION_OFFSET + 2, y);
    }
    get z() {
        return this.parent.rdramReadS16(ROTATION_OFFSET + 4);
    }
    set z(z) {
        this.parent.rdramWrite16(ROTATION_OFFSET + 4, z);
    }
    getRawRot() {
        return this.parent.rdramReadBuffer(ROTATION_OFFSET, ROTATION_SIZE);
    }
}
exports.Rotation = Rotation;
class ActorDeathBehavior {
    constructor(offset, behavior_calc) {
        this.offset = offset;
        this.behavior_calc = behavior_calc;
    }
}
exports.ActorDeathBehavior = ActorDeathBehavior;
exports.actorDeathBehaviorMap = new Map();
fs_1.default.readdirSync(path_1.default.join(__dirname, 'actorDeaths')).forEach((file) => {
    let parse = path_1.default.parse(file);
    if (parse.ext === '.js') {
        let cls = require(path_1.default.resolve(path_1.default.join(__dirname, 'actorDeaths', file)))[parse.name];
        let instance = new cls();
        exports.actorDeathBehaviorMap.set(instance.id, instance.death);
    }
});
function setActorBehavior(emulator, actor, offset, behavior) {
    let id = actor.actorID;
    let overlay_table = global.ModLoader['overlay_table'];
    let overlay_entry = overlay_table + id * 32;
    let behavior_start = overlay_entry + 0x10;
    let pointer = emulator.dereferencePointer(behavior_start);
    let behavior_result = pointer + behavior;
    actor.rdramWrite32(offset, behavior_result + 0x80000000);
}
exports.setActorBehavior = setActorBehavior;
function getActorBehavior(emulator, actor, offset) {
    let id = actor.actorID;
    let overlay_table = global.ModLoader['overlay_table'];
    let overlay_entry = overlay_table + id * 32;
    let behavior_start = overlay_entry + 0x10;
    let pointer = emulator.dereferencePointer(behavior_start);
    let behavior = actor.dereferencePointer(offset);
    return behavior - pointer;
}
exports.getActorBehavior = getActorBehavior;
class ActorBase extends JSONTemplate_1.JSONTemplate {
    constructor(emulator, pointer) {
        super();
        this.actorUUID = '';
        this.exists = true;
        this.jsonFields = [
            'actorID',
            'actorUUID',
            'health',
            'rotation',
            'position',
        ];
        this.emulator = emulator;
        this.instance = pointer;
        this.rotation = new Rotation(this);
        this.position = new Position(this);
    }
    get actorID() {
        return this.rdramRead16(0x0);
    }
    get actorType() {
        return this.rdramRead8(0x2);
    }
    get room() {
        return this.rdramRead8(0x3);
    }
    set room(r) {
        this.rdramWrite8(0x3, r);
    }
    get renderingFlags() {
        return this.rdramRead32(0x4);
    }
    set renderingFlags(flags) {
        this.rdramWrite32(0x4, flags);
    }
    get variable() {
        return this.rdramRead16(0x1c);
    }
    get objectTableIndex() {
        return this.rdramRead8(0x1e);
    }
    get soundEffect() {
        return this.rdramRead16(0x20);
    }
    set soundEffect(s) {
        this.rdramWrite16(0x20, s);
    }
    get health() {
        return this.rdramRead8(0xaf);
    }
    set health(h) {
        this.rdramWrite8(0xaf, h);
    }
    get redeadFreeze() {
        return this.rdramReadS16(0x110);
    }
    set redeadFreeze(f) {
        this.rdramWrite16(0x110, f);
    }
    destroy() {
        if (exports.actorDeathBehaviorMap.has(this.actorID)) {
            let b = exports.actorDeathBehaviorMap.get(this.actorID);
            setActorBehavior(this.emulator, this, b.offset, b.behavior_calc);
        }
        else {
            this.rdramWrite32(0x130, 0x0);
            this.rdramWrite32(0x134, 0x0);
        }
    }
    rdramRead8(addr) {
        return this.emulator.rdramRead8(this.instance + addr);
    }
    rdramWrite8(addr, value) {
        this.emulator.rdramWrite8(this.instance + addr, value);
    }
    rdramRead16(addr) {
        return this.emulator.rdramRead16(this.instance + addr);
    }
    rdramWrite16(addr, value) {
        this.emulator.rdramWrite16(this.instance + addr, value);
    }
    rdramWrite32(addr, value) {
        this.emulator.rdramWrite32(this.instance + addr, value);
    }
    rdramRead32(addr) {
        return this.emulator.rdramRead32(this.instance + addr);
    }
    rdramReadBuffer(addr, size) {
        return this.emulator.rdramReadBuffer(this.instance + addr, size);
    }
    rdramWriteBuffer(addr, buf) {
        this.emulator.rdramWriteBuffer(this.instance + addr, buf);
    }
    dereferencePointer(addr) {
        return this.emulator.dereferencePointer(this.instance + addr);
    }
    rdramReadS8(addr) {
        return this.emulator.rdramReadS8(this.instance + addr);
    }
    rdramReadS16(addr) {
        return this.emulator.rdramReadS16(this.instance + addr);
    }
    rdramReadS32(addr) {
        return this.emulator.rdramReadS32(this.instance + addr);
    }
    rdramReadBitsBuffer(addr, bytes) {
        return this.emulator.rdramReadBitsBuffer(this.instance + addr, bytes);
    }
    rdramReadBits8(addr) {
        return this.emulator.rdramReadBits8(this.instance + addr);
    }
    rdramReadBit8(addr, bitoffset) {
        return this.emulator.rdramReadBit8(this.instance + addr, bitoffset);
    }
    rdramWriteBitsBuffer(addr, buf) {
        this.emulator.rdramWriteBitsBuffer(this.instance + addr, buf);
    }
    rdramWriteBits8(addr, buf) {
        this.emulator.rdramWriteBits8(this.instance + addr, buf);
    }
    rdramWriteBit8(addr, bitoffset, bit) {
        this.emulator.rdramWriteBit8(this.instance + addr, bitoffset, bit);
    }
    rdramReadPtr8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead8(pointer + offset);
    }
    rdramWritePtr8(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite8(pointer + offset, value);
    }
    rdramReadPtr16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead16(pointer + offset);
    }
    rdramWritePtr16(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite16(pointer + offset, value);
    }
    rdramWritePtr32(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWrite32(pointer + offset, value);
    }
    rdramReadPtr32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramRead32(pointer + offset);
    }
    rdramReadPtrBuffer(addr, offset, size) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBuffer(pointer + offset, size);
    }
    rdramWritePtrBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBuffer(pointer + offset, buf);
    }
    rdramReadPtrS8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS8(pointer + offset);
    }
    rdramReadPtrS16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS16(pointer + offset);
    }
    rdramReadPtrS32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadS32(pointer + offset);
    }
    rdramReadPtrBitsBuffer(addr, offset, bytes) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBitsBuffer(pointer + offset, bytes);
    }
    rdramReadPtrBits8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBits8(pointer + offset);
    }
    rdramReadPtrBit8(addr, offset, bitoffset) {
        let pointer = this.dereferencePointer(addr);
        return this.emulator.rdramReadBit8(pointer + offset, bitoffset);
    }
    rdramWritePtrBitsBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBitsBuffer(pointer + offset, buf);
    }
    rdramWritePtrBits8(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBits8(pointer + offset, buf);
    }
    rdramWritePtrBit8(addr, offset, bitoffset, bit) {
        let pointer = this.dereferencePointer(addr);
        this.emulator.rdramWriteBit8(pointer + offset, bitoffset, bit);
    }
}
exports.ActorBase = ActorBase;
//# sourceMappingURL=Actor.js.map