/// <reference types="node" />
import IMemory from 'modloader64_api/IMemory';
import { JSONTemplate } from 'modloader64_api/JSONTemplate';
import { ActorCategory } from 'modloader64_api/OOT/ActorCategory';
import { IRotation } from 'modloader64_api/OOT/IRotation';
import { IPosition } from 'modloader64_api/OOT/IPosition';
import { IActor } from 'modloader64_api/OOT/IActor';
export declare class Position extends JSONTemplate implements IPosition {
    private readonly parent;
    jsonFields: string[];
    constructor(parent: IMemory);
    x: number;
    y: number;
    z: number;
    getRawPos(): Buffer;
}
export declare class Rotation extends JSONTemplate implements IRotation {
    private readonly parent;
    jsonFields: string[];
    constructor(parent: IMemory);
    x: number;
    y: number;
    z: number;
    getRawRot(): Buffer;
}
export declare class ActorDeathBehavior {
    offset: number;
    behavior_calc: number;
    constructor(offset: number, behavior_calc: number);
}
export interface IActorDeathFile {
    id: number;
    death: ActorDeathBehavior;
}
export declare const actorDeathBehaviorMap: Map<number, ActorDeathBehavior>;
export declare function setActorBehavior(emulator: IMemory, actor: IActor, offset: number, behavior: number): void;
export declare function getActorBehavior(emulator: IMemory, actor: IActor, offset: number): number;
export declare class ActorBase extends JSONTemplate implements IActor {
    actorUUID: string;
    private readonly emulator;
    instance: number;
    exists: boolean;
    rotation: IRotation;
    position: IPosition;
    jsonFields: string[];
    constructor(emulator: IMemory, pointer: number);
    readonly actorID: number;
    readonly actorType: ActorCategory;
    room: number;
    renderingFlags: number;
    readonly variable: number;
    readonly objectTableIndex: number;
    soundEffect: number;
    health: number;
    redeadFreeze: number;
    destroy(): void;
    rdramRead8(addr: number): number;
    rdramWrite8(addr: number, value: number): void;
    rdramRead16(addr: number): number;
    rdramWrite16(addr: number, value: number): void;
    rdramWrite32(addr: number, value: number): void;
    rdramRead32(addr: number): number;
    rdramReadBuffer(addr: number, size: number): Buffer;
    rdramWriteBuffer(addr: number, buf: Buffer): void;
    dereferencePointer(addr: number): number;
    rdramReadS8(addr: number): number;
    rdramReadS16(addr: number): number;
    rdramReadS32(addr: number): number;
    rdramReadBitsBuffer(addr: number, bytes: number): Buffer;
    rdramReadBits8(addr: number): Buffer;
    rdramReadBit8(addr: number, bitoffset: number): boolean;
    rdramWriteBitsBuffer(addr: number, buf: Buffer): void;
    rdramWriteBits8(addr: number, buf: Buffer): void;
    rdramWriteBit8(addr: number, bitoffset: number, bit: boolean): void;
    rdramReadPtr8(addr: number, offset: number): number;
    rdramWritePtr8(addr: number, offset: number, value: number): void;
    rdramReadPtr16(addr: number, offset: number): number;
    rdramWritePtr16(addr: number, offset: number, value: number): void;
    rdramWritePtr32(addr: number, offset: number, value: number): void;
    rdramReadPtr32(addr: number, offset: number): number;
    rdramReadPtrBuffer(addr: number, offset: number, size: number): Buffer;
    rdramWritePtrBuffer(addr: number, offset: number, buf: Buffer): void;
    rdramReadPtrS8(addr: number, offset: number): number;
    rdramReadPtrS16(addr: number, offset: number): number;
    rdramReadPtrS32(addr: number, offset: number): number;
    rdramReadPtrBitsBuffer(addr: number, offset: number, bytes: number): Buffer;
    rdramReadPtrBits8(addr: number, offset: number): Buffer;
    rdramReadPtrBit8(addr: number, offset: number, bitoffset: number): boolean;
    rdramWritePtrBitsBuffer(addr: number, offset: number, buf: Buffer): void;
    rdramWritePtrBits8(addr: number, offset: number, buf: Buffer): void;
    rdramWritePtrBit8(addr: number, offset: number, bitoffset: number, bit: boolean): void;
}
