"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const EventHandler_1 = require("modloader64_api/EventHandler");
const IModLoaderAPI_1 = require("modloader64_api/IModLoaderAPI");
const VersionHandler_1 = require("./DK64/VersionHandler");
const API = __importStar(require("modloader64_api/DK64/Imports"));
// ##################################################################
// ##  Sub-Classes
// ##################################################################
class GameFlags extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["DK64:save_game_flags" /* SAVE_GAME_FLAGS */], 0x013b);
    }
}
exports.GameFlags = GameFlags;
// ##################################################################
// ##  Primary-Classes
// ##################################################################
class Player extends API.BaseObj {
}
exports.Player = Player;
class Runtime extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.cur_profile_addr = global.ModLoader["DK64:rt_current_profile" /* RT_CUR_PROFILE */];
        this.game_mode_addr = global.ModLoader["DK64:rt_game_mode" /* RT_GAME_MODE */];
    }
    get_current_profile() {
        return this.emulator.rdramRead8(this.cur_profile_addr);
    }
    get_game_mode() {
        return this.emulator.rdramRead8(this.game_mode_addr);
    }
}
exports.Runtime = Runtime;
class SaveContext extends API.BaseObj {
    constructor(emu) {
        super(emu);
        this.game_flags = new GameFlags(emu);
    }
}
exports.SaveContext = SaveContext;
class DonkeyKong64 {
    constructor() {
        this.header = 'DONKEY KONG 64';
        this.ModLoader = {};
        this.eventTicks = new Map();
    }
    isPlaying() {
        return this.runtime.get_game_mode() === API.GameModeType.ADVENTURE;
    }
    preinit() {
        switch (this.rom_header.country_code) {
            case 'J':
                this.version = 0 /* JP_1_0 */;
                VersionHandler_1.VersionHandler.load_jp_1_0();
                break;
            case 'P':
                this.version = 1 /* PAL_1_0 */;
                VersionHandler_1.VersionHandler.load_pal_1_0();
                break;
            case 'E':
                this.version = 2 /* USA_1_0 */;
                VersionHandler_1.VersionHandler.load_usa_1_0();
                break;
        }
    }
    init() { }
    postinit() {
        this.player = new Player(this.ModLoader.emulator);
        this.runtime = new Runtime(this.ModLoader.emulator);
        this.save = new SaveContext(this.ModLoader.emulator);
    }
    onTick() {
        this.eventTicks.forEach((value, key) => {
            value();
        });
    }
    onModLoader_RomHeaderParsed(header) { }
    onCore_InjectFinished(evt) { }
}
__decorate([
    EventHandler_1.EventHandler(IModLoaderAPI_1.ModLoaderEvents.ON_ROM_HEADER_PARSED)
], DonkeyKong64.prototype, "onModLoader_RomHeaderParsed", null);
__decorate([
    EventHandler_1.EventHandler(EventHandler_1.EventsClient.ON_INJECT_FINISHED)
], DonkeyKong64.prototype, "onCore_InjectFinished", null);
exports.DonkeyKong64 = DonkeyKong64;
exports.default = DonkeyKong64;
//# sourceMappingURL=DonkeyKong64.js.map