/// <reference types="node" />
import { IModLoaderAPI, ICore } from 'modloader64_api/IModLoaderAPI';
import { IRomHeader } from 'modloader64_api/IRomHeader';
import IMemory from 'modloader64_api/IMemory';
import * as API from 'modloader64_api/DK64/Imports';
export declare class GameFlags extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class Player extends API.BaseObj implements API.IPlayer {
}
export declare class Runtime extends API.BaseObj implements API.IRuntime {
    private cur_profile_addr;
    private game_mode_addr;
    get_current_profile(): API.ProfileType;
    get_game_mode(): API.GameModeType;
}
export declare class SaveContext extends API.BaseObj implements API.ISaveContext {
    game_flags: API.IBuffered;
    constructor(emu: IMemory);
}
export declare class DonkeyKong64 implements ICore, API.IDK64Core {
    header: string;
    ModLoader: IModLoaderAPI;
    eventTicks: Map<string, Function>;
    rom_header: IRomHeader;
    player: API.IPlayer;
    runtime: API.IRuntime;
    save: API.ISaveContext;
    version: API.GameVersion;
    isPlaying(): boolean;
    preinit(): void;
    init(): void;
    postinit(): void;
    onTick(): void;
    onModLoader_RomHeaderParsed(header: Buffer): void;
    onCore_InjectFinished(evt: any): void;
}
export default DonkeyKong64;
