"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const EventHandler_1 = require("modloader64_api/EventHandler");
const IModLoaderAPI_1 = require("modloader64_api/IModLoaderAPI");
const VersionHandler_1 = require("./BT/VersionHandler");
const API = __importStar(require("modloader64_api/BT/Imports"));
// ##################################################################
// ##  Sub-Classes
// ##################################################################
class GameFlags extends API.BufferPtrObj {
    constructor(emu) {
        super(emu, global.ModLoader["BT:save_game_flags" /* SAVE_GAME_FLAGS */], 0xaf);
    }
}
exports.GameFlags = GameFlags;
// ##################################################################
// ##  Primary-Classes
// ##################################################################
class Player extends API.BaseObj {
    exists() {
        return false; //!(this.emulator.rdramRead32(this.instance) === 0x0000);
    }
}
exports.Player = Player;
class Runtime extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.prof_hover_addr = global.ModLoader["BT:rt_prof_hover" /* RT_PROF_HOVER */];
        this.prof_select_addr = global.ModLoader["BT:rt_prof_select" /* RT_PROF_SELECT */];
    }
    get_profile_hovering() {
        return this.emulator.rdramReadS8(this.prof_hover_addr);
    }
    get_profile_selected() {
        return this.emulator.rdramReadS8(this.prof_select_addr);
    }
}
exports.Runtime = Runtime;
class SaveContext extends API.BaseObj {
    constructor(emu) {
        super(emu);
        this.game_flags = new GameFlags(emu);
    }
}
exports.SaveContext = SaveContext;
class BanjoTooie {
    constructor() {
        this.header = 'BANJO TOOIE';
        this.ModLoader = {};
        this.eventTicks = new Map();
    }
    isPlaying() {
        return (this.runtime.get_profile_hovering() === API.ProfileType.Title &&
            this.runtime.get_profile_selected() !== API.ProfileType.Title);
    }
    preinit() {
        switch (this.rom_header.country_code) {
            case 'U':
                this.version = 0 /* AUS_1_0 */;
                VersionHandler_1.VersionHandler.load_aus_1_0();
                break;
            case 'J':
                this.version = 1 /* JP_1_0 */;
                VersionHandler_1.VersionHandler.load_jp_1_0();
                break;
            case 'P':
                this.version = 2 /* PAL_1_0 */;
                VersionHandler_1.VersionHandler.load_pal_1_0();
                break;
            case 'E':
                this.version = 3 /* USA_1_0 */;
                VersionHandler_1.VersionHandler.load_usa_1_0();
                break;
        }
    }
    init() { }
    postinit() {
        this.player = new Player(this.ModLoader.emulator);
        this.runtime = new Runtime(this.ModLoader.emulator);
        this.save = new SaveContext(this.ModLoader.emulator);
    }
    onTick() {
        this.eventTicks.forEach((value, key) => {
            value();
        });
    }
    onModLoader_RomHeaderParsed(header) { }
    onCore_InjectFinished(evt) { }
}
__decorate([
    EventHandler_1.EventHandler(IModLoaderAPI_1.ModLoaderEvents.ON_ROM_HEADER_PARSED)
], BanjoTooie.prototype, "onModLoader_RomHeaderParsed", null);
__decorate([
    EventHandler_1.EventHandler(EventHandler_1.EventsClient.ON_INJECT_FINISHED)
], BanjoTooie.prototype, "onCore_InjectFinished", null);
exports.BanjoTooie = BanjoTooie;
exports.default = BanjoTooie;
//# sourceMappingURL=BanjoTooie.js.map