/// <reference types="node" />
import { IModLoaderAPI, ICore } from 'modloader64_api/IModLoaderAPI';
import { IRomHeader } from 'modloader64_api/IRomHeader';
import IMemory from 'modloader64_api/IMemory';
import * as API from 'modloader64_api/BT/Imports';
export declare class GameFlags extends API.BufferPtrObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class Player extends API.BaseObj implements API.IPlayer {
    exists(): boolean;
}
export declare class Runtime extends API.BaseObj implements API.IRuntime {
    private prof_hover_addr;
    private prof_select_addr;
    get_profile_hovering(): API.ProfileType;
    get_profile_selected(): API.ProfileType;
}
export declare class SaveContext extends API.BaseObj implements API.ISaveContext {
    game_flags: API.IBuffered;
    constructor(emu: IMemory);
}
export declare class BanjoTooie implements ICore, API.IBTCore {
    header: string;
    ModLoader: IModLoaderAPI;
    eventTicks: Map<string, Function>;
    rom_header: IRomHeader;
    player: API.IPlayer;
    runtime: API.IRuntime;
    save: API.ISaveContext;
    version: API.GameVersion;
    isPlaying(): boolean;
    preinit(): void;
    init(): void;
    postinit(): void;
    onTick(): void;
    onModLoader_RomHeaderParsed(header: Buffer): void;
    onCore_InjectFinished(evt: any): void;
}
export default BanjoTooie;
