"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const EventHandler_1 = require("modloader64_api/EventHandler");
const IModLoaderAPI_1 = require("modloader64_api/IModLoaderAPI");
const VersionHandler_1 = require("./BK/VersionHandler");
const API = __importStar(require("modloader64_api/BK/Imports"));
// ##################################################################
// ##  Sub-Classes
// ##################################################################
class GameFlags extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["BK:save_game_flags" /* SAVE_GAME_FLAGS */], 0x20);
    }
}
exports.GameFlags = GameFlags;
class HoneyCombFlags extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["BK:save_honeycomb_flags" /* SAVE_HONEYCOMB_FLAGS */], 0x03);
    }
}
exports.HoneyCombFlags = HoneyCombFlags;
class JiggyFlags extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["BK:save_jiggy_flags" /* SAVE_JIGGY_FLAGS */], 0x0d);
    }
}
exports.JiggyFlags = JiggyFlags;
class MumboTokenFlags extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["BK:save_mumbo_token_flags" /* SAVE_MUMBO_TOKEN_FLAGS */], 0x10);
    }
}
exports.MumboTokenFlags = MumboTokenFlags;
class NoteTotalBuffer extends API.BufferObj {
    constructor(emu) {
        super(emu, global.ModLoader["BK:save_note_totals" /* SAVE_NOTE_TOTALS */], 0x0f);
    }
}
exports.NoteTotalBuffer = NoteTotalBuffer;
class CurrentLevel extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.id_addr = global.ModLoader["BK:rt_current_level" /* RT_CUR_LEVEL */];
        this.acorn_addr = global.ModLoader["BK:rt_acorn" /* RT_CUR_LEVEL_ACORN */];
        this.caterpillar_addr = global.ModLoader["BK:rt_caterpillar" /* RT_CUR_LEVEL_CATERPILLAR */];
        this.gold_bullions_addr = global.ModLoader["BK:rt_gold_bullion" /* RT_CUR_LEVEL_GOLD_BULLION */];
        this.jinjos_addr = global.ModLoader["BK:rt_current_level_jinjos" /* RT_CUR_LEVEL_JINJOS */];
        this.notes_addr = global.ModLoader["BK:rt_current_level_notes" /* RT_CUR_LEVEL_NOTES */];
        this.present_green_addr = global.ModLoader["BK:rt_present_green" /* RT_CUR_LEVEL_PRESENT_GREEN */];
        this.present_blue_addr = global.ModLoader["BK:rt_present_blue" /* RT_CUR_LEVEL_PRESENT_BLUE */];
        this.present_red_addr = global.ModLoader["BK:rt_present_red" /* RT_CUR_LEVEL_PRESENT_RED */];
        this.orange_addr = global.ModLoader["BK:rt_orange" /* RT_CUR_LEVEL_ORANGE */];
    }
    get id() {
        let level = this.emulator.rdramRead8(this.id_addr);
        if (level < API.LevelType.MUMBOS_MOUNTAIN ||
            level > API.LevelType.TITLE_SCREEN) {
            return API.LevelType.UNKNOWN;
        }
        else {
            return level;
        }
    }
    set id(val) {
        this.emulator.rdramWrite8(this.id_addr, val);
    }
    get acorn() {
        return this.emulator.rdramRead32(this.acorn_addr);
    }
    set acorn(val) {
        this.emulator.rdramWrite32(this.acorn_addr, val);
    }
    get caterpillar() {
        return this.emulator.rdramRead32(this.caterpillar_addr);
    }
    set caterpillar(val) {
        this.emulator.rdramWrite32(this.caterpillar_addr, val);
    }
    get gold_bullions() {
        return this.emulator.rdramRead32(this.gold_bullions_addr);
    }
    set gold_bullions(val) {
        this.emulator.rdramWrite32(this.gold_bullions_addr, val);
    }
    get jinjos() {
        return this.emulator.rdramRead32(this.jinjos_addr);
    }
    set jinjos(val) {
        this.emulator.rdramWrite32(this.jinjos_addr, val);
    }
    get notes() {
        return this.emulator.rdramRead32(this.notes_addr);
    }
    set notes(val) {
        this.emulator.rdramWrite32(this.notes_addr, val);
    }
    get present_green() {
        return this.emulator.rdramRead32(this.present_green_addr);
    }
    set present_green(val) {
        this.emulator.rdramWrite32(this.present_green_addr, val);
    }
    get present_blue() {
        return this.emulator.rdramRead32(this.present_blue_addr);
    }
    set present_blue(val) {
        this.emulator.rdramWrite32(this.present_blue_addr, val);
    }
    get present_red() {
        return this.emulator.rdramRead32(this.present_red_addr);
    }
    set present_red(val) {
        this.emulator.rdramWrite32(this.present_red_addr, val);
    }
    get orange() {
        return this.emulator.rdramRead32(this.orange_addr);
    }
    set orange(val) {
        this.emulator.rdramWrite32(this.orange_addr, val);
    }
}
exports.CurrentLevel = CurrentLevel;
class Inventory extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.eggs_addr = global.ModLoader["BK:inv_eggs" /* INV_EGGS */];
        this.feathers_red_addr = global.ModLoader["BK:inv_red_feather" /* INV_RED_FEATHERS */];
        this.feathers_gold_addr = global.ModLoader["BK:inv_gold_feather" /* INV_GOLD_FEATHERS */];
        this.health_upgrade_addr = global.ModLoader["BK:inv_health_upgrades" /* INV_HEALTH_UPGRADES */];
        this.honeycombs_addr = global.ModLoader["BK:inv_honeycombs" /* INV_HONEYCOMBS */];
        this.jiggies_addr = global.ModLoader["BK:inv_jiggies" /* INV_JIGGIES */];
        this.mumbo_tokens_addr = global.ModLoader["BK:inv_mumbo_tokens" /* INV_MUMBO_TOKENS */];
        this.text_jiggies_addr = global.ModLoader["BK:inv_text_jiggies" /* INV_TEXT_JIGGIES */];
        this.text_mumbo_tokens_addr = global.ModLoader["BK:inv_text_mumbo_tokens" /* INV_TEXT_MUMBO_TOKENS */];
    }
    get eggs() {
        return this.emulator.rdramRead32(this.eggs_addr);
    }
    set eggs(val) {
        if (val < 0) {
            val = 0;
        }
        else if (val > 200) {
            val = 200;
        }
        this.emulator.rdramWrite32(this.eggs_addr, val);
    }
    get red_feathers() {
        return this.emulator.rdramRead32(this.feathers_red_addr);
    }
    set red_feathers(val) {
        if (val < 0) {
            val = 0;
        }
        else if (val > 100) {
            val = 100;
        }
        this.emulator.rdramWrite32(this.feathers_red_addr, val);
    }
    get gold_feathers() {
        return this.emulator.rdramRead32(this.feathers_gold_addr);
    }
    set gold_feathers(val) {
        if (val < 0) {
            val = 0;
        }
        else if (val > 20) {
            val = 20;
        }
        this.emulator.rdramWrite32(this.feathers_gold_addr, val);
    }
    get health_upgrades() {
        return this.emulator.rdramRead32(this.health_upgrade_addr) - 5;
    }
    set health_upgrades(val) {
        if (val < 0)
            val = 0;
        this.emulator.rdramWrite32(this.health_upgrade_addr, val + 5);
    }
    get honeycombs() {
        return this.emulator.rdramRead32(this.honeycombs_addr);
    }
    set honeycombs(val) {
        if (val > 6) {
            val = 6;
        }
        else if (val < 0) {
            val = 0;
        }
        this.emulator.rdramWrite32(this.honeycombs_addr, val);
    }
    get jiggies() {
        return this.emulator.rdramRead32(this.jiggies_addr);
    }
    set jiggies(val) {
        if (val < 0)
            val = 0;
        this.emulator.rdramWrite32(this.jiggies_addr, val);
        this.emulator.rdramWrite32(this.text_jiggies_addr, val);
    }
    get mumbo_tokens() {
        return this.emulator.rdramRead32(this.mumbo_tokens_addr);
    }
    set mumbo_tokens(val) {
        if (val < 0)
            val = 0;
        this.emulator.rdramWrite32(this.mumbo_tokens_addr, val);
        this.emulator.rdramWrite32(this.text_mumbo_tokens_addr, val);
    }
}
exports.Inventory = Inventory;
// ##################################################################
// ##  Primary-Classes
// ##################################################################
class Player extends API.BaseObj {
    constructor() {
        super(...arguments);
        this.animal_addr = global.ModLoader["BK:plyr_animal" /* PLYR_ANIMAL */];
        this.anim_addr = global.ModLoader["BK:plyr_animation" /* PLYR_ANIMATION */];
        this.flip_facing_addr = global.ModLoader["BK:plyr_flip_facing" /* PLYR_FLIP_FACING */];
        this.model_index_addr = global.ModLoader["BK:plyr_model_index" /* PLYR_MODEL_INDEX */];
        this.model_ptr_addr = global.ModLoader["BK:plyr_model_ptr" /* PLYR_MODEL_PTR */];
        this.movement_state_addr = global.ModLoader["BK:plyr_state" /* PLYR_MOVEMENT_STATE */];
        this.opacity_addr = global.ModLoader["BK:plyr_opacity" /* PLYR_OPACITY */];
        this.pos_x_addr = global.ModLoader["BK:plyr_pos_x" /* PLYR_POS_X */];
        this.pos_y_addr = global.ModLoader["BK:plyr_pos_y" /* PLYR_POS_Y */];
        this.pos_z_addr = global.ModLoader["BK:plyr_pos_z" /* PLYR_POS_Z */];
        this.rot_x_addr = global.ModLoader["BK:plyr_rot_x" /* PLYR_ROT_X */];
        this.rot_y_addr = global.ModLoader["BK:plyr_rot_y" /* PLYR_ROT_Y */];
        this.rot_z_addr = global.ModLoader["BK:plyr_rot_z" /* PLYR_ROT_Z */];
        this.scale_addr = global.ModLoader["BK:plyr_scale" /* PLYR_SCALE */];
        this.visible_addr = global.ModLoader["BK:plyr_visible" /* PLYR_VISIBLE */];
    }
    get animal() {
        let animal = this.emulator.rdramRead8(this.animal_addr);
        if (animal < 0x01 || animal > 0x07)
            return API.AnimalType.UNKNOWN;
        return animal;
    }
    set animal(val) {
        this.emulator.rdramWrite8(this.animal_addr, val);
    }
    get animation() {
        let buf = Buffer.alloc(8);
        buf.writeUInt32BE(this.emulator.rdramReadPtr32(this.anim_addr, 0x04), 0);
        buf.writeUInt32BE(this.emulator.rdramReadPtr32(this.anim_addr, 0x1c), 4);
        return buf;
    }
    set animation(val) {
        this.emulator.rdramWritePtrBuffer(this.anim_addr, 0x04, val.slice(0, 4));
        this.emulator.rdramWritePtrBuffer(this.anim_addr, 0x1c, val.slice(4, 8));
    }
    get anim_frame() {
        return this.emulator.rdramReadPtr32(this.anim_addr, 0x04);
    }
    set anim_frame(val) {
        this.emulator.rdramWritePtr32(this.anim_addr, 0x04, val);
    }
    get anim_id() {
        return this.emulator.rdramReadPtr32(this.anim_addr, 0x1c);
    }
    set anim_id(val) {
        this.emulator.rdramWritePtr32(this.anim_addr, 0x1c, val);
    }
    get flip_facing() {
        return this.emulator.rdramRead8(this.flip_facing_addr) === 0x01;
    }
    set flip_facing(val) {
        if (val) {
            this.emulator.rdramWrite8(this.flip_facing_addr, 0x01);
        }
        else {
            this.emulator.rdramWrite8(this.flip_facing_addr, 0x00);
        }
    }
    get model_index() {
        return this.emulator.rdramRead16(this.model_index_addr);
    }
    set model_index(val) {
        this.emulator.rdramWrite16(this.model_index_addr, val);
    }
    get model_ptr() {
        return this.emulator.dereferencePointer(this.model_ptr_addr);
    }
    set model_ptr(val) {
        this.emulator.rdramWrite32(this.model_ptr_addr, val);
    }
    get movement_state() {
        return this.emulator.rdramRead32(this.movement_state_addr);
    }
    set movement_state(val) {
        this.emulator.rdramWrite32(this.movement_state_addr, val);
    }
    get opacity() {
        return this.emulator.rdramRead8(this.opacity_addr);
    }
    set opacity(val) {
        if (val < 0) {
            val = 0;
        }
        else if (val > 255) {
            val = 255;
        }
        this.emulator.rdramWrite8(this.opacity_addr, val);
    }
    get position() {
        let buf = Buffer.alloc(12);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.pos_x_addr), 0);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.pos_y_addr), 4);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.pos_z_addr), 8);
        return buf;
    }
    set position(val) {
        this.emulator.rdramWriteBuffer(this.pos_x_addr, val.slice(0, 4));
        this.emulator.rdramWriteBuffer(this.pos_y_addr, val.slice(4, 8));
        this.emulator.rdramWriteBuffer(this.pos_z_addr, val.slice(8, 12));
    }
    get pos_x() {
        return this.emulator.rdramRead32(this.pos_x_addr);
    }
    set pos_x(val) {
        this.emulator.rdramWrite32(this.pos_x_addr, val);
    }
    get pos_y() {
        return this.emulator.rdramRead32(this.pos_y_addr);
    }
    set pos_y(val) {
        this.emulator.rdramWrite32(this.pos_y_addr, val);
    }
    get pos_z() {
        return this.emulator.rdramRead32(this.pos_z_addr);
    }
    set pos_z(val) {
        this.emulator.rdramWrite32(this.pos_z_addr, val);
    }
    get rotation() {
        let buf = Buffer.alloc(12);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.rot_x_addr), 0);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.rot_y_addr), 4);
        buf.writeUInt32BE(this.emulator.rdramRead32(this.rot_z_addr), 8);
        return buf;
    }
    set rotation(val) {
        this.emulator.rdramWriteBuffer(this.rot_x_addr, val.slice(0, 4));
        this.emulator.rdramWriteBuffer(this.rot_y_addr, val.slice(4, 8));
        this.emulator.rdramWriteBuffer(this.rot_z_addr, val.slice(8, 12));
    }
    get rot_x() {
        return this.emulator.rdramRead32(this.rot_x_addr);
    }
    set rot_x(val) {
        this.emulator.rdramWrite32(this.rot_x_addr, val);
    }
    get rot_y() {
        return this.emulator.rdramRead32(this.rot_y_addr);
    }
    set rot_y(val) {
        this.emulator.rdramWrite32(this.rot_y_addr, val);
    }
    get rot_z() {
        return this.emulator.rdramRead32(this.rot_z_addr);
    }
    set rot_z(val) {
        this.emulator.rdramWrite32(this.rot_z_addr, val);
    }
    get scale() {
        return this.emulator.rdramRead32(this.scale_addr);
    }
    set scale(val) {
        this.emulator.rdramWrite32(this.scale_addr, val);
    }
    get visible() {
        return this.emulator.rdramRead8(this.visible_addr) === 0x01;
    }
    set visible(val) {
        if (val) {
            this.emulator.rdramWrite8(this.visible_addr, 0x01);
        }
        else {
            this.emulator.rdramWrite8(this.visible_addr, 0x00);
        }
    }
}
exports.Player = Player;
class Runtime extends API.BaseObj {
    constructor(emu) {
        super(emu);
        this.cur_events_level_addr = global.ModLoader["BK:rt_current_level_events" /* RT_CUR_LEVEL_EVENTS */];
        this.cur_events_scene_addr = global.ModLoader["BK:rt_current_scene_events" /* RT_CUR_SCENE_EVENTS */];
        this.cur_exit_addr = global.ModLoader["BK:rt_current_exit" /* RT_CUR_EXIT */];
        this.cur_health_addr = global.ModLoader["BK:rt_current_health" /* RT_CUR_HEALTH */];
        this.cur_profile_addr = global.ModLoader["BK:rt_current_profile" /* RT_CUR_PROFILE */];
        this.cur_scene_addr = global.ModLoader["BK:rt_current_scene" /* RT_CUR_SCENE */];
        this.is_cutscene_addr = global.ModLoader["BK:rt_is_cutscene" /* RT_IS_CUTSCENE */];
        this.is_loading_addr = global.ModLoader["BK:rt_is_loading" /* RT_IS_LOADING */];
        this.transition_state_addr = global.ModLoader["BK:rt_transition_state" /* RT_TRANSITION_STATE */];
        this.current_level = new CurrentLevel(emu);
    }
    get current_exit() {
        let exit = this.emulator.rdramRead8(this.cur_exit_addr);
        if (exit < API.LevelType.MUMBOS_MOUNTAIN ||
            exit > API.LevelType.TITLE_SCREEN) {
            return API.ExitType.UNKNOWN;
        }
        else {
            return exit;
        }
    }
    set current_exit(val) {
        this.emulator.rdramWrite8(this.cur_exit_addr, val);
    }
    get current_health() {
        return this.emulator.rdramRead32(this.cur_health_addr);
    }
    set current_health(val) {
        if (val < 0)
            val = 0;
        this.emulator.rdramWrite32(this.cur_health_addr, val);
    }
    get current_level_events() {
        return this.emulator.rdramRead32(this.cur_events_level_addr);
    }
    set current_level_events(val) {
        this.emulator.rdramWrite32(this.cur_events_level_addr, val);
    }
    get current_scene() {
        let scene = this.emulator.rdramRead8(this.cur_scene_addr);
        if (scene < API.SceneType.SM_MAIN ||
            scene > API.SceneType.INTRO_GRUNTY_THREAT_2) {
            return API.SceneType.UNKNOWN;
        }
        else {
            return scene;
        }
    }
    set current_scene(val) {
        this.emulator.rdramWrite8(this.cur_scene_addr, val);
    }
    get current_scene_events() {
        return this.emulator.rdramRead32(this.cur_events_scene_addr);
    }
    set current_scene_events(val) {
        this.emulator.rdramWrite32(this.cur_events_scene_addr, val);
    }
    get_current_profile() {
        return this.emulator.rdramReadS32(this.cur_profile_addr);
    }
    is_cutscene() {
        return this.emulator.rdramRead32(this.is_cutscene_addr) !== 0;
    }
    is_loading() {
        return this.emulator.rdramRead8(this.is_loading_addr) !== 0;
    }
    get_transition_state() {
        return this.emulator.rdramRead8(this.transition_state_addr);
    }
    goto_scene(scene, exit) {
        this.emulator.rdramWrite8(this.cur_scene_addr, scene);
        this.emulator.rdramWrite8(this.cur_exit_addr, exit);
        this.emulator.rdramWrite8(this.is_loading_addr, 1);
    }
}
exports.Runtime = Runtime;
class SaveContext extends API.BaseObj {
    constructor(emu) {
        super(emu);
        this.move_addr = global.ModLoader["BK:save_move_flags" /* SAVE_MOVE_FLAGS */];
        this.inventory = new Inventory(emu);
        this.game_flags = new GameFlags(emu);
        this.honeycomb_flags = new HoneyCombFlags(emu);
        this.jiggy_flags = new JiggyFlags(emu);
        this.mumbo_token_flags = new MumboTokenFlags(emu);
        this.note_totals = new NoteTotalBuffer(emu);
    }
    get moves() {
        return this.emulator.rdramRead32(this.move_addr);
    }
    set moves(val) {
        this.emulator.rdramWrite32(this.move_addr, val);
    }
}
exports.SaveContext = SaveContext;
class BanjoKazooie {
    constructor() {
        this.header = 'Banjo-Kazooie';
        this.ModLoader = {};
        this.eventTicks = new Map();
    }
    isPlaying() {
        return !(this.player.movement_state === 0 ||
            this.runtime.get_current_profile() === API.ProfileType.Title);
    }
    preinit() {
        switch (this.rom_header.country_code) {
            case 'J':
                this.version = 0 /* JP_1_0 */;
                VersionHandler_1.VersionHandler.load_jp_1_0();
                break;
            case 'P':
                this.version = 1 /* PAL_1_0 */;
                VersionHandler_1.VersionHandler.load_pal_1_0();
                break;
            case 'E':
                if (this.rom_header.revision === 1) {
                    this.version = 3 /* USA_1_1 */;
                    VersionHandler_1.VersionHandler.load_usa_1_1();
                }
                else {
                    this.version = 2 /* USA_1_0 */;
                    VersionHandler_1.VersionHandler.load_usa_1_0();
                }
                break;
        }
    }
    init() { }
    postinit() {
        this.player = new Player(this.ModLoader.emulator);
        this.runtime = new Runtime(this.ModLoader.emulator);
        this.save = new SaveContext(this.ModLoader.emulator);
    }
    onTick() {
        this.eventTicks.forEach((value, key) => {
            value();
        });
    }
    onModLoader_RomHeaderParsed(header) { }
    onCore_InjectFinished(evt) { }
}
__decorate([
    EventHandler_1.EventHandler(IModLoaderAPI_1.ModLoaderEvents.ON_ROM_HEADER_PARSED)
], BanjoKazooie.prototype, "onModLoader_RomHeaderParsed", null);
__decorate([
    EventHandler_1.EventHandler(EventHandler_1.EventsClient.ON_INJECT_FINISHED)
], BanjoKazooie.prototype, "onCore_InjectFinished", null);
exports.BanjoKazooie = BanjoKazooie;
exports.default = BanjoKazooie;
//# sourceMappingURL=BanjoKazooie.js.map